package com.xforceplus.ultraman.app.jcvankepurchaser.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 业务单认证状态
 * </p>
 *
 * @author ultraman
 * @since 2023-09-26
 */
public enum OrderAuthStatus {

    _0("0", "未勾选"),
    _1("1", "已勾选"),
    _2("2", "部分勾选"),
    _3("3", "勾选异常"),
    _4("4", "已确认抵扣"),
    _5("5", "抵扣异常"),
    _6("6", "部分抵扣");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    OrderAuthStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static OrderAuthStatus fromCode(String code) {
        return Stream.of(OrderAuthStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
