package com.xforceplus.ultraman.app.jcvankepurchaser.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 业务单异常
 * </p>
 *
 * @author ultraman
 * @since 2023-09-26
 */
public enum OrderError {

    ORDERS_LEGAL_SYNERGETICS_MISSING("ordersLegalSynergeticsMissing", "业务单对应的购方法人信息不存在"),
    INVOICE_LEGAL_SYNERGETICS_MISSING("invoiceLegalSynergeticsMissing", "业务单下发票对应的购方法人信息不存在"),
    AMOUNT_ERROR("amountError", "业务单下发票不含税金额与税额之和不等于含税金额");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    OrderError(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static OrderError fromCode(String code) {
        return Stream.of(OrderError.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
