package com.xforceplus.ultraman.app.jcvankepurchaser.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 重算状态
 * </p>
 *
 * @author ultraman
 * @since 2023-09-26
 */
public enum RecalculationStatus {

    _0("0", "未重算"),
    _1("1", "重算中"),
    _2("2", "重算完成");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    RecalculationStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static RecalculationStatus fromCode(String code) {
        return Stream.of(RecalculationStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
