package com.xforceplus.ultraman.app.jcvankepurchaser.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 票据类型
 * </p>
 *
 * @author ultraman
 * @since 2023-09-26
 */
public enum ReceiptType {

    INV("inv", "发票收据"),
    VR("vr", "开票收据"),
    IR("ir", "内部收据");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ReceiptType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ReceiptType fromCode(String code) {
        return Stream.of(ReceiptType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
