package com.xforceplus.ultraman.app.jcvankepurchaser.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 卡单原因
 * </p>
 *
 * @author ultraman
 * @since 2023-09-26
 */
public enum StuckReason {

    _1("1", "业务单可抵扣，单下面的发票全部为普票"),
    _2("2", "业务单关联的发票，法人信息不存在于主数据且发票审核已通过"),
    _3("3", "法人协同标识变更"),
    _4("4", "一般纳税人变更为小规模纳税人"),
    _5("5", "单据价税合计与发票价税合计之和不一致"),
    _6("6", "发票已审核，可抵扣，但没有影像"),
    _7("7", "国信扫描识别号码代码识别有误、无法验真");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    StuckReason(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static StuckReason fromCode(String code) {
        return Stream.of(StuckReason.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
