package com.xforceplus.ultraman.app.jcvankepurchaser.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 订阅方名称
 * </p>
 *
 * @author ultraman
 * @since 2023-09-26
 */
public enum SubscriberName {

    EMAIL("EMAIL", "邮件订阅"),
    ORDER_END_CHECK_S_A_P("OrderEndCheckSAP", "SAP业务单月末对账"),
    ORDER_END_CHECK_E_A_S("OrderEndCheckEAS", "EAS业务单月末对账"),
    OVERDUED_SIGN("OverduedSign", "签收超期"),
    OVERDUED_SCAN("OverduedScan", "扫描超期"),
    OVERDUED_AUDIT("OverduedAudit", "审核超期"),
    OVERDUED_AUTH("OverduedAuth", "勾选超期"),
    ALERT_EARLY_SIGN("alertEarlySign", "签收预警"),
    ALERT_EARLY_SCAN("alertEarlyScan", "扫描预警"),
    ALERT_EARLY_AUDIT("alertEarlyAudit", "审核预警"),
    ALERT_EARLY_AUTH("alertEarlyAuth", "勾选预警"),
    RECALCULATION("recalculation", "生命周期重算");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    SubscriberName(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static SubscriberName fromCode(String code) {
        return Stream.of(SubscriberName.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
