package com.xforceplus.ultraman.app.jcvankepurchaser.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 时间类型
 * </p>
 *
 * @author ultraman
 * @since 2023-09-26
 */
public enum TimeType {

    MINUTE("minute", "分钟"),
    HOUR("hour", "小时");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    TimeType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static TimeType fromCode(String code) {
        return Stream.of(TimeType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
