package com.xforceplus.ultraman.app.jcvankepurchaser.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 是否
 * </p>
 *
 * @author ultraman
 * @since 2023-09-26
 */
public enum YesOrNo {

    _0("0", "无"),
    _1("1", "是"),
    __1("-1", "否");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    YesOrNo(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static YesOrNo fromCode(String code) {
        return Stream.of(YesOrNo.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
