package com.xforceplus.ultraman.app.jcvankepurchaser.metadata.entity;

import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * orders_endcheck
 * </p>
 *
 * @author ultraman
 * @since 2023-09-26
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class OrdersEndcheck implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;
  /**
   * 单据编号
   */
  private String salesbillNo;
  /**
   * 是否生成凭证
   */
  private String voucherCreated;
  /**
   * 是否可抵扣
   */
  private String canDeduction;
  /**
   * 单据发票状态
   */
  private String billInvoiceStatus;
  /**
   * 不含税金额
   */
  private BigDecimal intAmountWithoutTax;
  /**
   * 税额
   */
  private BigDecimal intTaxAmount;
  /**
   * 含税金额
   */
  private BigDecimal intAmountWithTax;
  /**
   * 比对状态
   */
  private String compareStatus;
  /**
   * 购方名称
   */
  private String purchaserName;
  /**
   * 是否需要抵扣
   */
  private String ifAuthFlag;
  /**
   * 认证不含税总金额
   */
  private BigDecimal authNotContaintAmount;
  /**
   * 业务单认证状态
   */
  private String orderAuthStatus;
  /**
   * id
   */
  private Long id;
  /**
   * 租户ID
   */
  private Long tenantId;
  /**
   * 租户代码
   */
  private String tenantCode;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;
  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;
  /**
   * 创建人ID
   */
  private Long createUserId;
  /**
   * 修改人ID
   */
  private Long updateUserId;
  /**
   * 创建人名字
   */
  private String createUserName;
  /**
   * 修改人名字
   */
  private String updateUserName;
  /**
   * 删除标记
   */
  private String deleteFlag;
  /**
   * 业务单状态
   */
  private String orderStatus;
  /**
   * 业务来源
   */
  private String businessSource;
  /**
   * 认证总税额
   */
  private BigDecimal authTaxAmount;
  /**
   * 购方税号
   */
  private String purchaserTaxNo;
  /**
   * 抵扣时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime authTime;
  /**
   * 比对结果
   */
  private String compareMessage;
  /**
   * 平台业务单id
   */
  private Long bizOrderId;


  public Map toOQSMap() {
      Map map = new HashMap();
      map.put("salesbillNo", salesbillNo);
      map.put("voucherCreated", voucherCreated);
      map.put("canDeduction", canDeduction);
      map.put("billInvoiceStatus", billInvoiceStatus);
      map.put("intAmountWithoutTax", intAmountWithoutTax);
      map.put("intTaxAmount", intTaxAmount);
      map.put("intAmountWithTax", intAmountWithTax);
      map.put("compareStatus", compareStatus);
      map.put("purchaserName", purchaserName);
      map.put("ifAuthFlag", ifAuthFlag);
      map.put("authNotContaintAmount", authNotContaintAmount);
      map.put("orderAuthStatus", orderAuthStatus);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("orderStatus", orderStatus);
      map.put("businessSource", businessSource);
      map.put("authTaxAmount", authTaxAmount);
      map.put("purchaserTaxNo", purchaserTaxNo);
      map.put("auth_time", BocpGenUtils.toTimestamp(authTime));
      map.put("compareMessage", compareMessage);
      map.put("bizOrderId", bizOrderId);

      return map;
  }

  public static OrdersEndcheck fromOQSMap(Map map) {
    if(map == null || map.isEmpty()) {
      return null;
    }
    OrdersEndcheck entity = new OrdersEndcheck();

    if(map.containsKey("salesbillNo")) {
      Object obj = map.get("salesbillNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSalesbillNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("voucherCreated")) {
      Object obj = map.get("voucherCreated");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setVoucherCreated((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("canDeduction")) {
      Object obj = map.get("canDeduction");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCanDeduction((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("billInvoiceStatus")) {
      Object obj = map.get("billInvoiceStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBillInvoiceStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("intAmountWithoutTax")) {
      Object obj = map.get("intAmountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setIntAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setIntAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setIntAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setIntAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setIntAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("intTaxAmount")) {
      Object obj = map.get("intTaxAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setIntTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setIntTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setIntTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setIntTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setIntTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("intAmountWithTax")) {
      Object obj = map.get("intAmountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setIntAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setIntAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setIntAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setIntAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setIntAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("compareStatus")) {
      Object obj = map.get("compareStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCompareStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserName")) {
      Object obj = map.get("purchaserName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ifAuthFlag")) {
      Object obj = map.get("ifAuthFlag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setIfAuthFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("authNotContaintAmount")) {
      Object obj = map.get("authNotContaintAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAuthNotContaintAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAuthNotContaintAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAuthNotContaintAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAuthNotContaintAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAuthNotContaintAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("orderAuthStatus")) {
      Object obj = map.get("orderAuthStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrderAuthStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("orderStatus")) {
      Object obj = map.get("orderStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrderStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("businessSource")) {
      Object obj = map.get("businessSource");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBusinessSource((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("authTaxAmount")) {
      Object obj = map.get("authTaxAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAuthTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAuthTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAuthTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAuthTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAuthTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("purchaserTaxNo")) {
      Object obj = map.get("purchaserTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaserTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("auth_time")) {
      Object obj = map.get("auth_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setAuthTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setAuthTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAuthTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setAuthTime(null);
      }
    }
    if(map.containsKey("compareMessage")) {
      Object obj = map.get("compareMessage");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCompareMessage((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bizOrderId")) {
      Object obj = map.get("bizOrderId");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setBizOrderId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setBizOrderId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setBizOrderId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("salesbillNo")) {
      Object obj = map.get("salesbillNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSalesbillNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("voucherCreated")) {
      Object obj = map.get("voucherCreated");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setVoucherCreated((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("canDeduction")) {
      Object obj = map.get("canDeduction");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCanDeduction((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("billInvoiceStatus")) {
      Object obj = map.get("billInvoiceStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBillInvoiceStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("intAmountWithoutTax")) {
      Object obj = map.get("intAmountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setIntAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setIntAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setIntAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setIntAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setIntAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("intTaxAmount")) {
      Object obj = map.get("intTaxAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setIntTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setIntTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setIntTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setIntTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setIntTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("intAmountWithTax")) {
      Object obj = map.get("intAmountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setIntAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setIntAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setIntAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setIntAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setIntAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("compareStatus")) {
      Object obj = map.get("compareStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCompareStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserName")) {
      Object obj = map.get("purchaserName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPurchaserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ifAuthFlag")) {
      Object obj = map.get("ifAuthFlag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setIfAuthFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("authNotContaintAmount")) {
      Object obj = map.get("authNotContaintAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setAuthNotContaintAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setAuthNotContaintAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setAuthNotContaintAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setAuthNotContaintAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setAuthNotContaintAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("orderAuthStatus")) {
      Object obj = map.get("orderAuthStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setOrderAuthStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("orderStatus")) {
      Object obj = map.get("orderStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setOrderStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("businessSource")) {
      Object obj = map.get("businessSource");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBusinessSource((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("authTaxAmount")) {
      Object obj = map.get("authTaxAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setAuthTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setAuthTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setAuthTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setAuthTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setAuthTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("purchaserTaxNo")) {
      Object obj = map.get("purchaserTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPurchaserTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("auth_time")) {
      Object obj = map.get("auth_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setAuthTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setAuthTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setAuthTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setAuthTime(null);
      }
    }
    if(map.containsKey("compareMessage")) {
      Object obj = map.get("compareMessage");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCompareMessage((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bizOrderId")) {
      Object obj = map.get("bizOrderId");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setBizOrderId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setBizOrderId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setBizOrderId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
  }
}
