package com.xforceplus.ultraman.app.jcvankepurchaser.metadata.meta;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.xforceplus.ultraman.bocp.gen.typed.TypedField;

/**
* 对象元数据
*
* @author ultraman
* @since 2023-09-26
*/
public class EntityMeta {
    public interface OqsengineSdkOmAuditLog {
        static Long id() {
            return 1673151714592096258L;
        }
        static String code() {
            return "oqsengineSdkOmAuditLog";
        }
        TypedField<Long> OPERATOR_ID = new TypedField<>(Long.class, "operator_id");
        TypedField<String> OPERATOR_CODE = new TypedField<>(String.class, "operator_code");
        TypedField<String> OPERATOR_NAME = new TypedField<>(String.class, "operator_name");
        TypedField<String> OPERATE_TYPE = new TypedField<>(String.class, "operate_type");
        TypedField<LocalDateTime> OPERATE_TIME = new TypedField<>(LocalDateTime.class, "operate_time");
        TypedField<Long> APP_ID = new TypedField<>(Long.class, "app_id");
        TypedField<String> APP_CODE = new TypedField<>(String.class, "app_code");
        TypedField<Long> BO_ID = new TypedField<>(Long.class, "bo_id");
        TypedField<String> BO_CODE = new TypedField<>(String.class, "bo_code");
        TypedField<String> BO_NAME = new TypedField<>(String.class, "bo_name");
        TypedField<Long> ENTITY_ID = new TypedField<>(Long.class, "entity_id");
        TypedField<String> ORIGIN_DATA = new TypedField<>(String.class, "origin_data");
        TypedField<String> REQUEST_DATA = new TypedField<>(String.class, "request_data");
        TypedField<String> RESPONSE_DATA = new TypedField<>(String.class, "response_data");
        TypedField<String> REMARK = new TypedField<>(String.class, "remark");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }
    public interface UltramanSysBoUserSetting {
        static Long id() {
            return 1673151715514843137L;
        }
        static String code() {
            return "ultramanSysBoUserSetting";
        }
        TypedField<String> CONFIG = new TypedField<>(String.class, "config");
        TypedField<String> STORE_KEY = new TypedField<>(String.class, "store_key");
        TypedField<String> EXTRA = new TypedField<>(String.class, "extra");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }
    public interface FlowInstanceLog {
        static Long id() {
            return 1673151716236263425L;
        }
        static String code() {
            return "flowInstanceLog";
        }
        TypedField<String> INSTANCE_ID = new TypedField<>(String.class, "instanceId");
        TypedField<String> FLOW_CODE = new TypedField<>(String.class, "flowCode");
        TypedField<String> ERROR_MSG = new TypedField<>(String.class, "errorMsg");
        TypedField<String> EXCEPTION_TRACE = new TypedField<>(String.class, "exceptionTrace");
        TypedField<String> ERROR_NODE_ID = new TypedField<>(String.class, "errorNodeId");
        TypedField<Boolean> ROLLBACK = new TypedField<>(Boolean.class, "rollback");
        TypedField<String> SNAPSHOT = new TypedField<>(String.class, "snapshot");
        TypedField<String> SNAPSHOT_FORMAT = new TypedField<>(String.class, "snapshotFormat");
        TypedField<String> ROLLBACK_NODE_ID = new TypedField<>(String.class, "rollbackNodeId");
        TypedField<String> FLOW_NAME = new TypedField<>(String.class, "flowName");
        TypedField<String> NODE_HISTORY = new TypedField<>(String.class, "nodeHistory");
        TypedField<String> STATUS = new TypedField<>(String.class, "status");
        TypedField<String> START_SNAPSHOT = new TypedField<>(String.class, "startSnapshot");
        TypedField<String> START_SNAPSHOT_FORMAT = new TypedField<>(String.class, "startSnapshotFormat");
        TypedField<String> COMPLETE_SNAPSHOT = new TypedField<>(String.class, "completeSnapshot");
        TypedField<String> COMPLETE_SNAPSHOT_FORMAT = new TypedField<>(String.class, "completeSnapshotFormat");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }
    public interface FlowReplayLog {
        static Long id() {
            return 1673151717217730562L;
        }
        static String code() {
            return "flowReplayLog";
        }
        TypedField<String> FLOW_INSTANCE_ID = new TypedField<>(String.class, "flowInstanceId");
        TypedField<String> FLOW_CODE = new TypedField<>(String.class, "flowCode");
        TypedField<String> ERROR_MSG = new TypedField<>(String.class, "errorMsg");
        TypedField<String> EXCEPTION_TRACE = new TypedField<>(String.class, "exceptionTrace");
        TypedField<String> ERROR_NODE_ID = new TypedField<>(String.class, "errorNodeId");
        TypedField<Boolean> ROLLBACK = new TypedField<>(Boolean.class, "rollback");
        TypedField<String> ROLLBACK_NODE_ID = new TypedField<>(String.class, "rollbackNodeId");
        TypedField<String> STATUS = new TypedField<>(String.class, "status");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }
    public interface PilotTaxNo {
        static Long id() {
            return 1678604851337539585L;
        }
        static String code() {
            return "pilotTaxNo";
        }
        TypedField<String> TAX_NO = new TypedField<>(String.class, "taxNo");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }
    public interface SupplierCompany {
        static Long id() {
            return 1682228657788088322L;
        }
        static String code() {
            return "supplierCompany";
        }
        TypedField<String> APPLY_SERIAL_NO = new TypedField<>(String.class, "applySerialNo");
        TypedField<String> APPLY_BATCH_NO = new TypedField<>(String.class, "applyBatchNo");
        TypedField<String> GROUP_CODE = new TypedField<>(String.class, "groupCode");
        TypedField<String> COMPANY_NO = new TypedField<>(String.class, "companyNo");
        TypedField<String> COMPANY_TYPE = new TypedField<>(String.class, "companyType");
        TypedField<String> COMPANY_TAX_NO = new TypedField<>(String.class, "companyTaxNo");
        TypedField<String> COMPANY_NAME = new TypedField<>(String.class, "companyName");
        TypedField<String> COMPANY_ADDR = new TypedField<>(String.class, "companyAddr");
        TypedField<String> COMPANY_TEL = new TypedField<>(String.class, "companyTel");
        TypedField<String> TAXPAYER_TYPE = new TypedField<>(String.class, "taxpayerType");
        TypedField<String> CONTACTOR_NAME = new TypedField<>(String.class, "contactorName");
        TypedField<String> CONTACTOR_EMAIL = new TypedField<>(String.class, "contactorEmail");
        TypedField<String> CONTACTOR_PHONE = new TypedField<>(String.class, "contactorPhone");
        TypedField<String> CONTACTOR_TEL = new TypedField<>(String.class, "contactorTel");
        TypedField<String> COMPANY_BANK_NAME = new TypedField<>(String.class, "companyBankName");
        TypedField<String> COMPANY_BANK_ACCOUNT = new TypedField<>(String.class, "companyBankAccount");
        TypedField<String> CASHIER_NAME = new TypedField<>(String.class, "cashierName");
        TypedField<String> CHECKER_NAME = new TypedField<>(String.class, "checkerName");
        TypedField<String> INVOICE_TYPE = new TypedField<>(String.class, "invoiceType");
        TypedField<BigDecimal> INVOICE_LIMIT_AMOUNT_C = new TypedField<>(BigDecimal.class, "invoiceLimitAmountC");
        TypedField<BigDecimal> INVOICE_LIMIT_AMOUNT_S = new TypedField<>(BigDecimal.class, "invoiceLimitAmountS");
        TypedField<String> TAX_DISK_TYPE = new TypedField<>(String.class, "taxDiskType");
        TypedField<String> INVOICE_MAKER = new TypedField<>(String.class, "invoiceMaker");
        TypedField<String> INVOICE_EMAIL = new TypedField<>(String.class, "invoiceEmail");
        TypedField<String> APPLY_USER_NAME = new TypedField<>(String.class, "applyUserName");
        TypedField<String> APPLY_USER_EMAIL = new TypedField<>(String.class, "applyUserEmail");
        TypedField<String> APPLY_USER_PHONE = new TypedField<>(String.class, "applyUserPhone");
        TypedField<String> IS_CREATE_USER = new TypedField<>(String.class, "isCreateUser");
        TypedField<String> AUDIT_FILE_URL = new TypedField<>(String.class, "auditFileUrl");
        TypedField<String> UN_CREDI_C_CODE = new TypedField<>(String.class, "unCrediCCode");
        TypedField<String> TAXDDRESS = new TypedField<>(String.class, "taxddress");
        TypedField<String> TAX_PHONE = new TypedField<>(String.class, "taxPhone");
        TypedField<LocalDateTime> ALTERATIO_T_TIME = new TypedField<>(LocalDateTime.class, "alteratioTTime");
        TypedField<String> NEW_COMPANY_ROLE_TYPE = new TypedField<>(String.class, "newCompanyRoleType");
        TypedField<String> NEW_COMPANY_TAX_NO = new TypedField<>(String.class, "newCompanyTaxNo");
        TypedField<String> NEW_COMPANY_NAME = new TypedField<>(String.class, "newCompanyName");
        TypedField<String> NEW_INVOICE_MAKER = new TypedField<>(String.class, "newInvoiceMaker");
        TypedField<String> DISPOSE_STATUS = new TypedField<>(String.class, "disposeStatus");
        TypedField<String> DISPOSE_INFO = new TypedField<>(String.class, "disposeInfo");
        TypedField<LocalDateTime> DISPOSE_DATE = new TypedField<>(LocalDateTime.class, "disposeDate");
        TypedField<LocalDateTime> SYNC_TIME = new TypedField<>(LocalDateTime.class, "syncTime");
        TypedField<String> REMARK = new TypedField<>(String.class, "remark");
        TypedField<String> COMPANY_DEPUTY_NO = new TypedField<>(String.class, "companyDeputyNo");
        TypedField<String> SUPPLIER_MDM_NUM = new TypedField<>(String.class, "supplierMdmNum");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> AUDIT_STATE = new TypedField<>(String.class, "auditState");
        TypedField<String> APPLY_MODIFY_TYPE = new TypedField<>(String.class, "applyModifyType");
        TypedField<String> IS_SYNERGETICS = new TypedField<>(String.class, "isSynergetics");
        TypedField<String> COMPANY_ROLE_TYPE = new TypedField<>(String.class, "companyRoleType");
        TypedField<String> DATA_FROM_SYSTEM = new TypedField<>(String.class, "dataFromSystem");
        TypedField<String> IN_USED = new TypedField<>(String.class, "inUsed");
    }
    public interface LegalPersonResume {
        static Long id() {
            return 1684463876247695361L;
        }
        static String code() {
            return "legalPersonResume";
        }
        TypedField<String> LEGAL_PERSON_CODE = new TypedField<>(String.class, "legalPersonCode");
        TypedField<String> LEGAL_PERSON_NAME = new TypedField<>(String.class, "legalPersonName");
        TypedField<String> TAX_NO = new TypedField<>(String.class, "taxNo");
        TypedField<LocalDateTime> OCCURRENCE_TIME = new TypedField<>(LocalDateTime.class, "occurrenceTime");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> LEGAL_PERSON_DATA_SOURCES = new TypedField<>(String.class, "legalPersonDataSources");
        TypedField<String> TASK_ID = new TypedField<>(String.class, "taskId");
    }
    public interface OrderLifeCircle {
        static Long id() {
            return 1689517326915923970L;
        }
        static String code() {
            return "orderLifeCircle";
        }
        TypedField<String> IS_OVER_DUED_SIGN = new TypedField<>(String.class, "isOverDuedSign");
        TypedField<String> IS_OVER_DUED_SCAN = new TypedField<>(String.class, "isOverDuedScan");
        TypedField<String> IS_OVER_DUED_AUDIT = new TypedField<>(String.class, "isOverDuedAudit");
        TypedField<String> IS_OVER_DUED_APPROVE = new TypedField<>(String.class, "isOverDuedApprove");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> BIZ_ORDER_NO = new TypedField<>(String.class, "biz_order_no");
        TypedField<String> BUSINESS_SOURCE = new TypedField<>(String.class, "businessSource");
        TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "purchaserName");
        TypedField<String> CAN_DEDUCTION = new TypedField<>(String.class, "canDeduction");
        TypedField<String> INVOICE_TYPE = new TypedField<>(String.class, "invoice_type");
        TypedField<String> COOPERATE_FLAG = new TypedField<>(String.class, "cooperate_flag");
        TypedField<String> DATA_FROM_SYSTEM = new TypedField<>(String.class, "dataFromSystem");
        TypedField<LocalDateTime> BILL_SIGN_TIME = new TypedField<>(LocalDateTime.class, "bill_sign_time");
        TypedField<LocalDateTime> RECOG_TIME = new TypedField<>(LocalDateTime.class, "recog_time");
        TypedField<LocalDateTime> AUDIT_TIME = new TypedField<>(LocalDateTime.class, "audit_time");
        TypedField<LocalDateTime> CHECK_TIME = new TypedField<>(LocalDateTime.class, "check_time");
        TypedField<LocalDateTime> PARCEL_SIGN_TIME = new TypedField<>(LocalDateTime.class, "parcel_sign_time");
        TypedField<String> IS_OVER_DUED = new TypedField<>(String.class, "isOverDued");
        TypedField<String> IS_RECALCULATION = new TypedField<>(String.class, "isRecalculation");
        TypedField<Long> THRESHOLD_SIGN = new TypedField<>(Long.class, "thresholdSign");
        TypedField<Long> THRESHOLD_SCAN = new TypedField<>(Long.class, "thresholdScan");
        TypedField<Long> THRESHOLD_AUDIT = new TypedField<>(Long.class, "thresholdAudit");
        TypedField<Long> THRESHOLD_APPROVE = new TypedField<>(Long.class, "thresholdApprove");
        TypedField<Long> OVER_DUE_TIME_SIGN = new TypedField<>(Long.class, "overDueTimeSign");
        TypedField<Long> OVER_DUE_TIME_SCAN = new TypedField<>(Long.class, "overDueTimeScan");
        TypedField<Long> OVER_DUE_TIME_AUDIT = new TypedField<>(Long.class, "overDueTimeAudit");
        TypedField<Long> OVER_DUE_TIME_APPROVE = new TypedField<>(Long.class, "overDueTimeApprove");
        TypedField<Long> WORK_TIME_SIGN = new TypedField<>(Long.class, "workTimeSign");
        TypedField<Long> WORK_TIME_SCAN = new TypedField<>(Long.class, "workTimeScan");
        TypedField<Long> WORK_TIME_AUDIT = new TypedField<>(Long.class, "workTimeAudit");
        TypedField<Long> WORK_TIME_APPROVE = new TypedField<>(Long.class, "workTimeApprove");
        TypedField<Long> BIZ_ORDER_ID = new TypedField<>(Long.class, "bizOrderId");
        TypedField<String> AUTH_STATUS = new TypedField<>(String.class, "authStatus");
        TypedField<String> PURCHASER_TAX_NO = new TypedField<>(String.class, "purchaserTaxNo");
        /**
         * 对一关联关系 关联对象 threshold
         */
        TypedField<Long> THRESHOLD_ID = new TypedField<>(Long.class, "threshold.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface THRESHOLD {
                static String code () {
                    return "threshold" ;
                }
                TypedField<Long> ID = new TypedField<>(Long.class, "threshold.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "threshold.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "threshold.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "threshold.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "threshold.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "threshold.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "threshold.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "threshold.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "threshold.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "threshold.delete_flag");
                TypedField<String> RECALCULATION_STATUS = new TypedField<>(String.class, "threshold.recalculationStatus");
                TypedField<String> THRESHOLD_SIGN_TIME_TYPE = new TypedField<>(String.class, "threshold.thresholdSignTimeType");
                TypedField<String> THRESHOLD_SCAN_TIME_TYPE = new TypedField<>(String.class, "threshold.thresholdScanTimeType");
                TypedField<String> THRESHOLD_AUDIT_TIME_TYPE = new TypedField<>(String.class, "threshold.thresholdAuditTimeType");
                TypedField<String> THRESHOLD_APPROVE_TIME_TYPE = new TypedField<>(String.class, "threshold.thresholdApproveTimeType");
                TypedField<String> ALERT_EARLY_SIGN_TIME_TYPE = new TypedField<>(String.class, "threshold.alertEarlySignTimeType");
                TypedField<String> ALERT_EARLY_SCAN_TIME_TYPE = new TypedField<>(String.class, "threshold.alertEarlyScanTimeType");
                TypedField<String> ALERT_EARLY_AUDIT_TIME_TYPE = new TypedField<>(String.class, "threshold.alertEarlyAuditTimeType");
                TypedField<String> ALERT_EARLY_APPROVE_TIME_TYPE = new TypedField<>(String.class, "threshold.alertEarlyApproveTimeType");
                TypedField<String> IS_THRESHOLD_SIGN_MODIFIED = new TypedField<>(String.class, "threshold.isThresholdSignModified");
                TypedField<String> IS_THRESHOLD_SCAN_MODIFIED = new TypedField<>(String.class, "threshold.isThresholdScanModified");
                TypedField<String> IS_THRESHOLD_AUDIT_MODIFIED = new TypedField<>(String.class, "threshold.isThresholdAuditModified");
                TypedField<String> IS_THRESHOLD_APPROVE_MODIFIED = new TypedField<>(String.class, "threshold.isThresholdApproveModified");
                TypedField<String> IS_ALERT_EARLY_SIGN_MODIFIED = new TypedField<>(String.class, "threshold.isAlertEarlySignModified");
                TypedField<String> IS_ALERT_EARLY_SCAN_MODIFIED = new TypedField<>(String.class, "threshold.isAlertEarlyScanModified");
                TypedField<String> IS_ALERT_EARLY_AUDIT_MODIFIED = new TypedField<>(String.class, "threshold.isAlertEarlyAuditModified");
                TypedField<String> IS_ALERT_EARLY_APPROVE_MODIFIED = new TypedField<>(String.class, "threshold.isAlertEarlyApproveModified");
                TypedField<LocalDateTime> MODIFICATION_TIME = new TypedField<>(LocalDateTime.class, "threshold.modificationTime");
                TypedField<LocalDateTime> RECALCULATE_COMPLETE_TIME = new TypedField<>(LocalDateTime.class, "threshold.recalculateCompleteTime");
                TypedField<Long> THRESHOLD_SIGN = new TypedField<>(Long.class, "threshold.thresholdSign");
                TypedField<Long> THRESHOLD_SCAN = new TypedField<>(Long.class, "threshold.thresholdScan");
                TypedField<Long> THRESHOLD_AUDIT = new TypedField<>(Long.class, "threshold.thresholdAudit");
                TypedField<Long> THRESHOLD_APPROVE = new TypedField<>(Long.class, "threshold.thresholdApprove");
                TypedField<Long> ALERT_EARLY_SIGN = new TypedField<>(Long.class, "threshold.alertEarlySign");
                TypedField<Long> ALERT_EARLY_SCAN = new TypedField<>(Long.class, "threshold.alertEarlyScan");
                TypedField<Long> ALERT_EARLY_AUDIT = new TypedField<>(Long.class, "threshold.alertEarlyAudit");
                TypedField<Long> ALERT_EARLY_APPROVE = new TypedField<>(Long.class, "threshold.alertEarlyApprove");
            }
        }
    }
    public interface OrdersEndcheck {
        static Long id() {
            return 1689529223739944961L;
        }
        static String code() {
            return "ordersEndcheck";
        }
        TypedField<String> SALESBILL_NO = new TypedField<>(String.class, "salesbillNo");
        TypedField<String> VOUCHER_CREATED = new TypedField<>(String.class, "voucherCreated");
        TypedField<String> CAN_DEDUCTION = new TypedField<>(String.class, "canDeduction");
        TypedField<String> BILL_INVOICE_STATUS = new TypedField<>(String.class, "billInvoiceStatus");
        TypedField<BigDecimal> INT_AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "intAmountWithoutTax");
        TypedField<BigDecimal> INT_TAX_AMOUNT = new TypedField<>(BigDecimal.class, "intTaxAmount");
        TypedField<BigDecimal> INT_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "intAmountWithTax");
        TypedField<String> COMPARE_STATUS = new TypedField<>(String.class, "compareStatus");
        TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "purchaserName");
        TypedField<String> IF_AUTH_FLAG = new TypedField<>(String.class, "ifAuthFlag");
        TypedField<BigDecimal> AUTH_NOT_CONTAINT_AMOUNT = new TypedField<>(BigDecimal.class, "authNotContaintAmount");
        TypedField<String> ORDER_AUTH_STATUS = new TypedField<>(String.class, "orderAuthStatus");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> ORDER_STATUS = new TypedField<>(String.class, "orderStatus");
        TypedField<String> BUSINESS_SOURCE = new TypedField<>(String.class, "businessSource");
        TypedField<BigDecimal> AUTH_TAX_AMOUNT = new TypedField<>(BigDecimal.class, "authTaxAmount");
        TypedField<String> PURCHASER_TAX_NO = new TypedField<>(String.class, "purchaserTaxNo");
        TypedField<LocalDateTime> AUTH_TIME = new TypedField<>(LocalDateTime.class, "auth_time");
        TypedField<String> COMPARE_MESSAGE = new TypedField<>(String.class, "compareMessage");
        TypedField<Long> BIZ_ORDER_ID = new TypedField<>(Long.class, "bizOrderId");
    }
    public interface Threshold {
        static Long id() {
            return 1689537625296269313L;
        }
        static String code() {
            return "threshold";
        }
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> RECALCULATION_STATUS = new TypedField<>(String.class, "recalculationStatus");
        TypedField<String> THRESHOLD_SIGN_TIME_TYPE = new TypedField<>(String.class, "thresholdSignTimeType");
        TypedField<String> THRESHOLD_SCAN_TIME_TYPE = new TypedField<>(String.class, "thresholdScanTimeType");
        TypedField<String> THRESHOLD_AUDIT_TIME_TYPE = new TypedField<>(String.class, "thresholdAuditTimeType");
        TypedField<String> THRESHOLD_APPROVE_TIME_TYPE = new TypedField<>(String.class, "thresholdApproveTimeType");
        TypedField<String> ALERT_EARLY_SIGN_TIME_TYPE = new TypedField<>(String.class, "alertEarlySignTimeType");
        TypedField<String> ALERT_EARLY_SCAN_TIME_TYPE = new TypedField<>(String.class, "alertEarlyScanTimeType");
        TypedField<String> ALERT_EARLY_AUDIT_TIME_TYPE = new TypedField<>(String.class, "alertEarlyAuditTimeType");
        TypedField<String> ALERT_EARLY_APPROVE_TIME_TYPE = new TypedField<>(String.class, "alertEarlyApproveTimeType");
        TypedField<String> IS_THRESHOLD_SIGN_MODIFIED = new TypedField<>(String.class, "isThresholdSignModified");
        TypedField<String> IS_THRESHOLD_SCAN_MODIFIED = new TypedField<>(String.class, "isThresholdScanModified");
        TypedField<String> IS_THRESHOLD_AUDIT_MODIFIED = new TypedField<>(String.class, "isThresholdAuditModified");
        TypedField<String> IS_THRESHOLD_APPROVE_MODIFIED = new TypedField<>(String.class, "isThresholdApproveModified");
        TypedField<String> IS_ALERT_EARLY_SIGN_MODIFIED = new TypedField<>(String.class, "isAlertEarlySignModified");
        TypedField<String> IS_ALERT_EARLY_SCAN_MODIFIED = new TypedField<>(String.class, "isAlertEarlyScanModified");
        TypedField<String> IS_ALERT_EARLY_AUDIT_MODIFIED = new TypedField<>(String.class, "isAlertEarlyAuditModified");
        TypedField<String> IS_ALERT_EARLY_APPROVE_MODIFIED = new TypedField<>(String.class, "isAlertEarlyApproveModified");
        TypedField<LocalDateTime> MODIFICATION_TIME = new TypedField<>(LocalDateTime.class, "modificationTime");
        TypedField<LocalDateTime> RECALCULATE_COMPLETE_TIME = new TypedField<>(LocalDateTime.class, "recalculateCompleteTime");
        TypedField<Long> THRESHOLD_SIGN = new TypedField<>(Long.class, "thresholdSign");
        TypedField<Long> THRESHOLD_SCAN = new TypedField<>(Long.class, "thresholdScan");
        TypedField<Long> THRESHOLD_AUDIT = new TypedField<>(Long.class, "thresholdAudit");
        TypedField<Long> THRESHOLD_APPROVE = new TypedField<>(Long.class, "thresholdApprove");
        TypedField<Long> ALERT_EARLY_SIGN = new TypedField<>(Long.class, "alertEarlySign");
        TypedField<Long> ALERT_EARLY_SCAN = new TypedField<>(Long.class, "alertEarlyScan");
        TypedField<Long> ALERT_EARLY_AUDIT = new TypedField<>(Long.class, "alertEarlyAudit");
        TypedField<Long> ALERT_EARLY_APPROVE = new TypedField<>(Long.class, "alertEarlyApprove");
    }
    public interface EmailTodoTask {
        static Long id() {
            return 1690907954029629442L;
        }
        static String code() {
            return "emailTodoTask";
        }
        TypedField<String> SUBJECT = new TypedField<>(String.class, "subject");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> CONTENT = new TypedField<>(String.class, "content");
        TypedField<String> BUSINESS_ID = new TypedField<>(String.class, "businessId");
        TypedField<String> RECEIVER_EMAIL = new TypedField<>(String.class, "receiverEmail");
    }
    public interface TodoTask {
        static Long id() {
            return 1690907954251927554L;
        }
        static String code() {
            return "todoTask";
        }
        TypedField<String> BUSINESS_ID = new TypedField<>(String.class, "businessId");
        TypedField<String> TODO_TASK_TOPIC = new TypedField<>(String.class, "todoTaskTopic");
        TypedField<String> CONTENT = new TypedField<>(String.class, "content");
        TypedField<Boolean> DELIVERY_STATUS = new TypedField<>(Boolean.class, "deliveryStatus");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<LocalDateTime> EXECUTION_TIME = new TypedField<>(LocalDateTime.class, "executionTime");
    }
    public interface DeliveredTodoTask {
        static Long id() {
            return 1690907954411311106L;
        }
        static String code() {
            return "deliveredTodoTask";
        }
        TypedField<String> TASK_STATUS = new TypedField<>(String.class, "taskStatus");
        TypedField<Long> RETRY_COUNT = new TypedField<>(Long.class, "retryCount");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> SUBSCRIBER_NAME = new TypedField<>(String.class, "subscriberName");
        TypedField<String> ERROR_INFO = new TypedField<>(String.class, "errorInfo");
        TypedField<LocalDateTime> NEXT_RETRY_TIME = new TypedField<>(LocalDateTime.class, "nextRetryTime");
        TypedField<String> FLOW_INSTANCE_ID = new TypedField<>(String.class, "flowInstanceId");
        TypedField<String> BUSINESS_ID = new TypedField<>(String.class, "businessId");
        TypedField<String> TOPIC = new TypedField<>(String.class, "topic");
        TypedField<String> CONTENT = new TypedField<>(String.class, "content");
        TypedField<LocalDateTime> EXECUTION_TIME = new TypedField<>(LocalDateTime.class, "executionTime");
        /**
         * 对一关联关系 关联对象 todoTask
         */
        TypedField<Long> DELIVERY_TODO_TASK_MANY_TO_ONE_TODO_TASK_ID = new TypedField<>(Long.class, "deliveryTodoTaskManyToOneTodoTask.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface DELIVERY_TODO_TASK_MANY_TO_ONE_TODO_TASK {
                static String code () {
                    return "deliveryTodoTaskManyToOneTodoTask" ;
                }
                TypedField<String> BUSINESS_ID = new TypedField<>(String.class, "deliveryTodoTaskManyToOneTodoTask.businessId");
                TypedField<String> TODO_TASK_TOPIC = new TypedField<>(String.class, "deliveryTodoTaskManyToOneTodoTask.todoTaskTopic");
                TypedField<String> CONTENT = new TypedField<>(String.class, "deliveryTodoTaskManyToOneTodoTask.content");
                TypedField<Boolean> DELIVERY_STATUS = new TypedField<>(Boolean.class, "deliveryTodoTaskManyToOneTodoTask.deliveryStatus");
                TypedField<Long> ID = new TypedField<>(Long.class, "deliveryTodoTaskManyToOneTodoTask.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "deliveryTodoTaskManyToOneTodoTask.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "deliveryTodoTaskManyToOneTodoTask.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "deliveryTodoTaskManyToOneTodoTask.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "deliveryTodoTaskManyToOneTodoTask.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "deliveryTodoTaskManyToOneTodoTask.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "deliveryTodoTaskManyToOneTodoTask.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "deliveryTodoTaskManyToOneTodoTask.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "deliveryTodoTaskManyToOneTodoTask.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "deliveryTodoTaskManyToOneTodoTask.delete_flag");
                TypedField<LocalDateTime> EXECUTION_TIME = new TypedField<>(LocalDateTime.class, "deliveryTodoTaskManyToOneTodoTask.executionTime");
            }
        }
    }
    public interface DeliveryRuleConfig {
        static Long id() {
            return 1690907954595860482L;
        }
        static String code() {
            return "deliveryRuleConfig";
        }
        TypedField<String> TOPIC = new TypedField<>(String.class, "topic");
        TypedField<String> SUBSCRIBER_NAME = new TypedField<>(String.class, "subscriberName");
        TypedField<Long> MAX_RETRY_COUNT = new TypedField<>(Long.class, "maxRetryCount");
        TypedField<Boolean> IS_OPEN = new TypedField<>(Boolean.class, "isOpen");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<Long> INTERVAL = new TypedField<>(Long.class, "interval");
    }
    public interface OrderErrorStatement {
        static Long id() {
            return 1692056705041534977L;
        }
        static String code() {
            return "orderErrorStatement";
        }
        TypedField<String> SALES_BILL_NO = new TypedField<>(String.class, "salesBillNo");
        TypedField<String> ORDER_ERROR = new TypedField<>(String.class, "orderError");
        TypedField<String> ORDER_ERROR_MSG = new TypedField<>(String.class, "orderErrorMsg");
        TypedField<String> BUSINESS_SOURCE = new TypedField<>(String.class, "businessSource");
        TypedField<String> ORDER_STATUS = new TypedField<>(String.class, "orderStatus");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> ORDER_INVOICE_TYPE = new TypedField<>(String.class, "orderInvoiceType");
        TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "purchaserName");
        TypedField<String> PURCHASER_TAX_NO = new TypedField<>(String.class, "purchaserTaxNo");
        TypedField<String> IS_ERROR = new TypedField<>(String.class, "isError");
        TypedField<Long> BIZ_ORDER_ID = new TypedField<>(Long.class, "bizOrderId");
    }
    public interface PerpetualCalendar {
        static Long id() {
            return 1693499932869234690L;
        }
        static String code() {
            return "perpetualCalendar";
        }
        TypedField<String> YEAR = new TypedField<>(String.class, "year");
        TypedField<String> MONTH = new TypedField<>(String.class, "month");
        TypedField<String> DAY = new TypedField<>(String.class, "day");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> IS_SPECIAL = new TypedField<>(String.class, "isSpecial");
        TypedField<String> IS_WORKDAY = new TypedField<>(String.class, "isWorkday");
        TypedField<String> AM_BEGIN = new TypedField<>(String.class, "amBegin");
        TypedField<String> AM_END = new TypedField<>(String.class, "amEnd");
        TypedField<String> PM_BEGIN = new TypedField<>(String.class, "pmBegin");
        TypedField<String> PM_END = new TypedField<>(String.class, "pmEnd");
        TypedField<Long> RUNING_HOUR = new TypedField<>(Long.class, "runingHour");
        TypedField<String> WEEKDAY = new TypedField<>(String.class, "weekday");
        TypedField<LocalDateTime> YEAR_MONTH_DAY = new TypedField<>(LocalDateTime.class, "yearMonthDay");
        TypedField<String> DATA_TYPE = new TypedField<>(String.class, "dataType");
    }
    public interface UserPerformance {
        static Long id() {
            return 1693556320076042241L;
        }
        static String code() {
            return "userPerformance";
        }
        TypedField<String> USER_NAME = new TypedField<>(String.class, "userName");
        TypedField<Long> PARCEL_SIGN_COUNT = new TypedField<>(Long.class, "parcelSignCount");
        TypedField<Long> ORDER_SIGN_COUNT = new TypedField<>(Long.class, "orderSignCount");
        TypedField<Long> INVOICE_SIGN_COUNT = new TypedField<>(Long.class, "invoiceSignCount");
        TypedField<Long> INVOICE_RECOG = new TypedField<>(Long.class, "invoiceRecog");
        TypedField<Long> INVOICE_AUDIT_COUNT = new TypedField<>(Long.class, "invoiceAuditCount");
        TypedField<Long> INVOICE_AUTH_COUNT = new TypedField<>(Long.class, "invoiceAuthCount");
        TypedField<Long> RISK_PARCEL_COUNT = new TypedField<>(Long.class, "riskParcelCount");
        TypedField<Long> RISK_ORDER_COUNT = new TypedField<>(Long.class, "riskOrderCount");
        TypedField<Long> RISK_INVOICE_COUNT = new TypedField<>(Long.class, "riskInvoiceCount");
        TypedField<LocalDateTime> WORK_DATE = new TypedField<>(LocalDateTime.class, "workDate");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }
    public interface StuckOrder {
        static Long id() {
            return 1697552884763201537L;
        }
        static String code() {
            return "stuckOrder";
        }
        TypedField<String> ORDER_NO = new TypedField<>(String.class, "orderNo");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> STUCK_REASON = new TypedField<>(String.class, "stuckReason");
        TypedField<String> STUCK_REASON_MSG = new TypedField<>(String.class, "stuckReasonMsg");
        TypedField<String> BIZ_ORDER_ID = new TypedField<>(String.class, "bizOrderId");
        TypedField<String> ORDER_AUTH_STATUS = new TypedField<>(String.class, "orderAuthStatus");
    }
    public interface BizOrder {
        static Long id() {
            return 1699317608017866754L;
        }
        static String code() {
            return "bizOrder";
        }
        TypedField<String> BIZ_ORDER_NO = new TypedField<>(String.class, "biz_order_no");
        TypedField<String> COOPERATE_FLAG = new TypedField<>(String.class, "cooperate_flag");
        TypedField<String> WAYBILL_NUMBER = new TypedField<>(String.class, "waybill_number");
        TypedField<LocalDateTime> BILL_SIGN_TIME = new TypedField<>(LocalDateTime.class, "bill_sign_time");
        TypedField<String> BILL_SIGN_USER_NAME = new TypedField<>(String.class, "bill_sign_user_name");
        TypedField<String> IS_QUALIFIED = new TypedField<>(String.class, "is_qualified");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> ORIGIN_BIZ_ORDER_NO = new TypedField<>(String.class, "origin_biz_order_no");
        TypedField<String> SELLER_NO = new TypedField<>(String.class, "seller_no");
        TypedField<String> SELLER_NAME = new TypedField<>(String.class, "seller_name");
        TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "seller_tax_no");
        TypedField<String> SELLER_TEL = new TypedField<>(String.class, "seller_tel");
        TypedField<String> SELLER_ADDRESS = new TypedField<>(String.class, "seller_address");
        TypedField<String> SELLER_BANK_NAME = new TypedField<>(String.class, "seller_bank_name");
        TypedField<String> SELLER_BANK_ACCOUNT = new TypedField<>(String.class, "seller_bank_account");
        TypedField<Long> SELLER_TENANT_ID = new TypedField<>(Long.class, "seller_tenant_id");
        TypedField<Long> SELLER_ID = new TypedField<>(Long.class, "seller_id");
        TypedField<String> PURCHASER_NO = new TypedField<>(String.class, "purchaser_no");
        TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "purchaser_name");
        TypedField<String> PURCHASER_TAX_NO = new TypedField<>(String.class, "purchaser_tax_no");
        TypedField<String> PURCHASER_TEL = new TypedField<>(String.class, "purchaser_tel");
        TypedField<String> PURCHASER_ADDRESS = new TypedField<>(String.class, "purchaser_address");
        TypedField<String> PURCHASER_BANK_NAME = new TypedField<>(String.class, "purchaser_bank_name");
        TypedField<Long> PURCHASER_ID = new TypedField<>(Long.class, "purchaser_id");
        TypedField<String> BUSINESS_BILL_TYPE = new TypedField<>(String.class, "business_bill_type");
        TypedField<String> TAX_INVOICE_SOURCE = new TypedField<>(String.class, "tax_invoice_source");
        TypedField<String> SYSTEM_ORIG = new TypedField<>(String.class, "system_orig");
        TypedField<String> BIZ_ORDER_TYPE = new TypedField<>(String.class, "biz_order_type");
        TypedField<String> RECEIPT_TYPE = new TypedField<>(String.class, "receipt_type");
        TypedField<String> PRICE_METHOD = new TypedField<>(String.class, "price_method");
        TypedField<BigDecimal> AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "amount_with_tax");
        TypedField<BigDecimal> AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "amount_without_tax");
        TypedField<BigDecimal> TAX_AMOUNT = new TypedField<>(BigDecimal.class, "tax_amount");
        TypedField<BigDecimal> ORIGIN_AMOUNT = new TypedField<>(BigDecimal.class, "origin_amount");
        TypedField<BigDecimal> ALREADY_MAKE_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "already_make_amount_with_tax");
        TypedField<BigDecimal> ALREADY_MAKE_AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "already_make_amount_without_tax");
        TypedField<BigDecimal> ALREADY_MAKE_AMOUNT_TAX_AMOUNT = new TypedField<>(BigDecimal.class, "already_make_amount_tax_amount");
        TypedField<BigDecimal> ABANDON_FREEZE_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "abandon_freeze_amount_with_tax");
        TypedField<BigDecimal> ABANDON_FREEZE_AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "abandon_freeze_amount_without_tax");
        TypedField<BigDecimal> ABANDON_FREEZE_AMOUNT_TAX_AMOUNT = new TypedField<>(BigDecimal.class, "abandon_freeze_amount_tax_amount");
        TypedField<BigDecimal> DISCOUNT_WITH_TAX_TOTAL = new TypedField<>(BigDecimal.class, "discount_with_tax_total");
        TypedField<BigDecimal> DISCOUNT_WITHOUT_TAX_TOTAL = new TypedField<>(BigDecimal.class, "discount_without_tax_total");
        TypedField<BigDecimal> DISCOUNT_TAX_AMOUNT_TOTAL = new TypedField<>(BigDecimal.class, "discount_tax_amount_total");
        TypedField<BigDecimal> OUTTER_DISCOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "outter_discount_with_tax");
        TypedField<BigDecimal> OUTTER_DISCOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "outter_discount_without_tax");
        TypedField<BigDecimal> INNER_DISCOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "inner_discount_with_tax");
        TypedField<BigDecimal> INNER_DISCOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "inner_discount_without_tax");
        TypedField<BigDecimal> OUTTER_PREPAY_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "outter_prepay_amount_with_tax");
        TypedField<BigDecimal> OUTTER_PREPAY_AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "outter_prepay_amount_without_tax");
        TypedField<BigDecimal> INNER_PREPAY_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "inner_prepay_amount_with_tax");
        TypedField<BigDecimal> INNER_PREPAY_AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "inner_prepay_amount_without_tax");
        TypedField<String> UPLOAD_CONFIRM_FLAG = new TypedField<>(String.class, "upload_confirm_flag");
        TypedField<String> RECEIVE_CONFIRM_FLAG = new TypedField<>(String.class, "receive_confirm_flag");
        TypedField<String> MAKEOUT_STATUS = new TypedField<>(String.class, "makeout_status");
        TypedField<String> STATUS = new TypedField<>(String.class, "status");
        TypedField<Long> MODIFY_MARK = new TypedField<>(Long.class, "modify_mark");
        TypedField<String> COOPERATE_MODIFY_STATUS = new TypedField<>(String.class, "cooperate_modify_status");
        TypedField<String> ORIGIN_INVOICE_NO = new TypedField<>(String.class, "origin_invoice_no");
        TypedField<String> ORIGIN_INVOICE_CODE = new TypedField<>(String.class, "origin_invoice_code");
        TypedField<String> ORIGIN_INVOICE_TYPE = new TypedField<>(String.class, "origin_invoice_type");
        TypedField<String> ORIGIN_PAPER_DRAW_DATE = new TypedField<>(String.class, "origin_paper_draw_date");
        TypedField<String> RED_NOTIFICATION = new TypedField<>(String.class, "red_notification");
        TypedField<String> CHECKER_NAME = new TypedField<>(String.class, "checker_name");
        TypedField<String> CASHIER_NAME = new TypedField<>(String.class, "cashier_name");
        TypedField<String> INVOICER_NAME = new TypedField<>(String.class, "invoicer_name");
        TypedField<String> RECEIVE_USER_EMAIL = new TypedField<>(String.class, "receive_user_email");
        TypedField<String> RECEIVE_USER_TEL = new TypedField<>(String.class, "receive_user_tel");
        TypedField<Long> SYS_ORG_ID = new TypedField<>(Long.class, "sys_org_id");
        TypedField<String> USING_STATUS = new TypedField<>(String.class, "using_status");
        TypedField<String> CUSTOMER_NO = new TypedField<>(String.class, "customer_no");
        TypedField<String> ADDRESSEE = new TypedField<>(String.class, "addressee");
        TypedField<String> ADDRESSEE_TEL = new TypedField<>(String.class, "addressee_tel");
        TypedField<String> ADDRESSEE_PROVINCE = new TypedField<>(String.class, "addressee_province");
        TypedField<String> ADDRESSEE_CITY = new TypedField<>(String.class, "addressee_city");
        TypedField<String> ADDRESSEE_COUNTY = new TypedField<>(String.class, "addressee_county");
        TypedField<String> DIRECTION = new TypedField<>(String.class, "direction");
        TypedField<String> INVOICE_TYPE = new TypedField<>(String.class, "invoice_type");
        TypedField<String> LOGISTIC_REMARK = new TypedField<>(String.class, "logistic_remark");
        TypedField<String> REMARK = new TypedField<>(String.class, "remark");
        TypedField<String> EXT1 = new TypedField<>(String.class, "ext1");
        TypedField<String> EXT2 = new TypedField<>(String.class, "ext2");
        TypedField<String> EXT3 = new TypedField<>(String.class, "ext3");
        TypedField<String> EXT4 = new TypedField<>(String.class, "ext4");
        TypedField<String> EXT5 = new TypedField<>(String.class, "ext5");
        TypedField<String> EXT6 = new TypedField<>(String.class, "ext6");
        TypedField<String> EXT7 = new TypedField<>(String.class, "ext7");
        TypedField<String> EXT8 = new TypedField<>(String.class, "ext8");
        TypedField<String> EXT9 = new TypedField<>(String.class, "ext9");
        TypedField<String> EXT10 = new TypedField<>(String.class, "ext10");
        TypedField<String> EXT11 = new TypedField<>(String.class, "ext11");
        TypedField<String> EXT12 = new TypedField<>(String.class, "ext12");
        TypedField<String> EXT13 = new TypedField<>(String.class, "ext13");
        TypedField<String> EXT14 = new TypedField<>(String.class, "ext14");
        TypedField<String> EXT15 = new TypedField<>(String.class, "ext15");
        TypedField<String> EXT16 = new TypedField<>(String.class, "ext16");
        TypedField<String> EXT17 = new TypedField<>(String.class, "ext17");
        TypedField<String> EXT18 = new TypedField<>(String.class, "ext18");
        TypedField<String> EXT19 = new TypedField<>(String.class, "ext19");
        TypedField<String> EXT20 = new TypedField<>(String.class, "ext20");
        TypedField<String> EXT21 = new TypedField<>(String.class, "ext21");
        TypedField<String> EXT22 = new TypedField<>(String.class, "ext22");
        TypedField<String> EXT23 = new TypedField<>(String.class, "ext23");
        TypedField<String> EXT24 = new TypedField<>(String.class, "ext24");
        TypedField<String> EXT25 = new TypedField<>(String.class, "ext25");
        TypedField<String> AUDIT_STATUS = new TypedField<>(String.class, "audit_status");
        TypedField<String> SYSTEM_ORIG_TYPE = new TypedField<>(String.class, "system_orig_type");
        TypedField<String> APPLY_INVALID_FLAG = new TypedField<>(String.class, "apply_invalid_flag");
        TypedField<String> MATCH_STATUS = new TypedField<>(String.class, "match_status");
        TypedField<String> MAKING_REASON = new TypedField<>(String.class, "making_reason");
        TypedField<String> IMPORT_BATCH_NO = new TypedField<>(String.class, "import_batch_no");
        TypedField<String> POS_DATE = new TypedField<>(String.class, "pos_date");
        TypedField<Long> CHANNEL = new TypedField<>(Long.class, "channel");
        TypedField<String> PROCESS_REMARK = new TypedField<>(String.class, "process_remark");
        TypedField<String> PURCHASER_TYPE = new TypedField<>(String.class, "purchaser_type");
        TypedField<LocalDateTime> AUDIT_TIME = new TypedField<>(LocalDateTime.class, "audit_time");
        TypedField<String> AUTH_STATUS = new TypedField<>(String.class, "auth_status");
        TypedField<LocalDateTime> CHECK_TIME = new TypedField<>(LocalDateTime.class, "check_time");
        TypedField<LocalDateTime> AUTH_TIME = new TypedField<>(LocalDateTime.class, "auth_time");
        TypedField<String> RECOG_STATUS = new TypedField<>(String.class, "recog_status");
        TypedField<LocalDateTime> RECOG_TIME = new TypedField<>(LocalDateTime.class, "recog_time");
        TypedField<String> IS_NEED_AUTH = new TypedField<>(String.class, "is_need_auth");
        TypedField<BigDecimal> EFFECTIVE_TAX_AMOUNT = new TypedField<>(BigDecimal.class, "effective_tax_amount");
        TypedField<String> EXCEPTION_TYPE = new TypedField<>(String.class, "exception_type");
        TypedField<String> EXCEPTION_REMARK = new TypedField<>(String.class, "exception_remark");
        TypedField<LocalDateTime> PARCEL_SIGN_TIME = new TypedField<>(LocalDateTime.class, "parcel_sign_time");
        TypedField<String> PARCEL_SIGN_USER_NAME = new TypedField<>(String.class, "parcel_sign_user_name");
        TypedField<Long> DELETE_TOKEN = new TypedField<>(Long.class, "delete_token");
        TypedField<String> SELLER_ORG_CODE = new TypedField<>(String.class, "seller_org_code");
        TypedField<String> PURCHASER_ORG_CODE = new TypedField<>(String.class, "purchaser_org_code");
        TypedField<String> AUDIT_NAME = new TypedField<>(String.class, "audit_name");
        TypedField<String> PURCHASER_BANK_ACCOUNT = new TypedField<>(String.class, "purchaser_bank_account");
        TypedField<String> CHECK_STATUS = new TypedField<>(String.class, "check_status");
        TypedField<String> TAX_RATE = new TypedField<>(String.class, "tax_rate");
        TypedField<LocalDateTime> MAKEOUT_TIME = new TypedField<>(LocalDateTime.class, "makeout_time");
        TypedField<String> AUTO_CHECK_STATUS = new TypedField<>(String.class, "auto_check_status");
    }
    public interface OperationLog {
        static Long id() {
            return 1699598396181491714L;
        }
        static String code() {
            return "operationLog";
        }
        TypedField<String> BUSINESS_NO = new TypedField<>(String.class, "businessNo");
        TypedField<String> PARCEL_SIGN_STATUS = new TypedField<>(String.class, "parcelSignStatus");
        TypedField<String> ORDER_SIGN_STATUS = new TypedField<>(String.class, "orderSignStatus");
        TypedField<String> INVOICE_RECOG_STATUS = new TypedField<>(String.class, "invoiceRecogStatus");
        TypedField<String> ORDER_AUDIT_STATUS = new TypedField<>(String.class, "orderAuditStatus");
        TypedField<String> INVOICE_AUTH_STATUS = new TypedField<>(String.class, "invoiceAuthStatus");
        TypedField<String> RISK_PARCEL_STATUS = new TypedField<>(String.class, "riskParcelStatus");
        TypedField<String> RISK_ORDER_STATUS = new TypedField<>(String.class, "riskOrderStatus");
        TypedField<String> RISK_INVOICE_STATUS = new TypedField<>(String.class, "riskInvoiceStatus");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }
}
