package com.xforceplus.ultraman.app.jcvankepurchaser.metadata.validator;

import com.xforceplus.ultraman.app.jcvankepurchaser.metadata.validator.annotation.CheckUltramanEnum;

import com.xforceplus.ultraman.app.jcvankepurchaser.metadata.dict.*;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

/**
 * <p>
 * UltramanEnumConstraintValidator
 * </p>
 *
 * @author ultraman
 * @since 2023-09-26
 */
public class UltramanEnumConstraintValidator implements ConstraintValidator<CheckUltramanEnum, String> {

    private final String MSG_FORMAT = "value must be the code of one of enum %s";

    Class clazz;

    @Override
    public void initialize(CheckUltramanEnum constraintAnnotation) {
        clazz = constraintAnnotation.value();
    }

    @Override
    public boolean isValid(String value, ConstraintValidatorContext context) {
        if(null == value || value.length() == 0) {
            return true;
        }

        boolean isValid = true;

        if(clazz.equals(FlowStatus.class)) {
            isValid = null != FlowStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, FlowStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(SnapshotFormat.class)) {
            isValid = null != SnapshotFormat.fromCode(value);
            if(!isValid) {
                unValidMsg(context, SnapshotFormat.class.getSimpleName());
            }
        }
        if(clazz.equals(CompanyRoleType.class)) {
            isValid = null != CompanyRoleType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, CompanyRoleType.class.getSimpleName());
            }
        }
        if(clazz.equals(DataFromSystem.class)) {
            isValid = null != DataFromSystem.fromCode(value);
            if(!isValid) {
                unValidMsg(context, DataFromSystem.class.getSimpleName());
            }
        }
        if(clazz.equals(IsSynergetics.class)) {
            isValid = null != IsSynergetics.fromCode(value);
            if(!isValid) {
                unValidMsg(context, IsSynergetics.class.getSimpleName());
            }
        }
        if(clazz.equals(ApplyModifyType.class)) {
            isValid = null != ApplyModifyType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ApplyModifyType.class.getSimpleName());
            }
        }
        if(clazz.equals(AuditState.class)) {
            isValid = null != AuditState.fromCode(value);
            if(!isValid) {
                unValidMsg(context, AuditState.class.getSimpleName());
            }
        }
        if(clazz.equals(LegalPersonDataSources.class)) {
            isValid = null != LegalPersonDataSources.fromCode(value);
            if(!isValid) {
                unValidMsg(context, LegalPersonDataSources.class.getSimpleName());
            }
        }
        if(clazz.equals(IsOverDued.class)) {
            isValid = null != IsOverDued.fromCode(value);
            if(!isValid) {
                unValidMsg(context, IsOverDued.class.getSimpleName());
            }
        }
        if(clazz.equals(BusinessSource.class)) {
            isValid = null != BusinessSource.fromCode(value);
            if(!isValid) {
                unValidMsg(context, BusinessSource.class.getSimpleName());
            }
        }
        if(clazz.equals(YesOrNo.class)) {
            isValid = null != YesOrNo.fromCode(value);
            if(!isValid) {
                unValidMsg(context, YesOrNo.class.getSimpleName());
            }
        }
        if(clazz.equals(IsVoucherCreated.class)) {
            isValid = null != IsVoucherCreated.fromCode(value);
            if(!isValid) {
                unValidMsg(context, IsVoucherCreated.class.getSimpleName());
            }
        }
        if(clazz.equals(CanDeduction.class)) {
            isValid = null != CanDeduction.fromCode(value);
            if(!isValid) {
                unValidMsg(context, CanDeduction.class.getSimpleName());
            }
        }
        if(clazz.equals(BillInvoiceStatus.class)) {
            isValid = null != BillInvoiceStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, BillInvoiceStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(OrderAuthStatus.class)) {
            isValid = null != OrderAuthStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, OrderAuthStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(CompareStatus.class)) {
            isValid = null != CompareStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, CompareStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(OrderStatus.class)) {
            isValid = null != OrderStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, OrderStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(CooperateFlag.class)) {
            isValid = null != CooperateFlag.fromCode(value);
            if(!isValid) {
                unValidMsg(context, CooperateFlag.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceType.class)) {
            isValid = null != InvoiceType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, InvoiceType.class.getSimpleName());
            }
        }
        if(clazz.equals(TaskStatus.class)) {
            isValid = null != TaskStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, TaskStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(TodoTaskTopic.class)) {
            isValid = null != TodoTaskTopic.fromCode(value);
            if(!isValid) {
                unValidMsg(context, TodoTaskTopic.class.getSimpleName());
            }
        }
        if(clazz.equals(SubscriberName.class)) {
            isValid = null != SubscriberName.fromCode(value);
            if(!isValid) {
                unValidMsg(context, SubscriberName.class.getSimpleName());
            }
        }
        if(clazz.equals(OrderError.class)) {
            isValid = null != OrderError.fromCode(value);
            if(!isValid) {
                unValidMsg(context, OrderError.class.getSimpleName());
            }
        }
        if(clazz.equals(OrderInvoiceType.class)) {
            isValid = null != OrderInvoiceType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, OrderInvoiceType.class.getSimpleName());
            }
        }
        if(clazz.equals(DayOfWeek.class)) {
            isValid = null != DayOfWeek.fromCode(value);
            if(!isValid) {
                unValidMsg(context, DayOfWeek.class.getSimpleName());
            }
        }
        if(clazz.equals(RecalculationStatus.class)) {
            isValid = null != RecalculationStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, RecalculationStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(TimeType.class)) {
            isValid = null != TimeType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, TimeType.class.getSimpleName());
            }
        }
        if(clazz.equals(DataType.class)) {
            isValid = null != DataType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, DataType.class.getSimpleName());
            }
        }
        if(clazz.equals(CompareMessage.class)) {
            isValid = null != CompareMessage.fromCode(value);
            if(!isValid) {
                unValidMsg(context, CompareMessage.class.getSimpleName());
            }
        }
        if(clazz.equals(StuckReason.class)) {
            isValid = null != StuckReason.fromCode(value);
            if(!isValid) {
                unValidMsg(context, StuckReason.class.getSimpleName());
            }
        }
        if(clazz.equals(ExceptionType.class)) {
            isValid = null != ExceptionType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ExceptionType.class.getSimpleName());
            }
        }
        if(clazz.equals(IsQualified.class)) {
            isValid = null != IsQualified.fromCode(value);
            if(!isValid) {
                unValidMsg(context, IsQualified.class.getSimpleName());
            }
        }
        if(clazz.equals(CooperateFlag1693983864680.class)) {
            isValid = null != CooperateFlag1693983864680.fromCode(value);
            if(!isValid) {
                unValidMsg(context, CooperateFlag1693983864680.class.getSimpleName());
            }
        }
        if(clazz.equals(BusinessBillType.class)) {
            isValid = null != BusinessBillType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, BusinessBillType.class.getSimpleName());
            }
        }
        if(clazz.equals(BillInvoiceType.class)) {
            isValid = null != BillInvoiceType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, BillInvoiceType.class.getSimpleName());
            }
        }
        if(clazz.equals(PriceMethod.class)) {
            isValid = null != PriceMethod.fromCode(value);
            if(!isValid) {
                unValidMsg(context, PriceMethod.class.getSimpleName());
            }
        }
        if(clazz.equals(TaxInvoiceSource.class)) {
            isValid = null != TaxInvoiceSource.fromCode(value);
            if(!isValid) {
                unValidMsg(context, TaxInvoiceSource.class.getSimpleName());
            }
        }
        if(clazz.equals(ReceiptType.class)) {
            isValid = null != ReceiptType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ReceiptType.class.getSimpleName());
            }
        }
        if(clazz.equals(UsingStatus.class)) {
            isValid = null != UsingStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, UsingStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(CooperateModifyStatus.class)) {
            isValid = null != CooperateModifyStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, CooperateModifyStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(BillStatus.class)) {
            isValid = null != BillStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, BillStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(MakeoutStatus.class)) {
            isValid = null != MakeoutStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, MakeoutStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(UploadConfirmFlag.class)) {
            isValid = null != UploadConfirmFlag.fromCode(value);
            if(!isValid) {
                unValidMsg(context, UploadConfirmFlag.class.getSimpleName());
            }
        }
        if(clazz.equals(ReceiveConfirmFlag.class)) {
            isValid = null != ReceiveConfirmFlag.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ReceiveConfirmFlag.class.getSimpleName());
            }
        }
        if(clazz.equals(PurchaserType.class)) {
            isValid = null != PurchaserType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, PurchaserType.class.getSimpleName());
            }
        }
        if(clazz.equals(MakingReason.class)) {
            isValid = null != MakingReason.fromCode(value);
            if(!isValid) {
                unValidMsg(context, MakingReason.class.getSimpleName());
            }
        }
        if(clazz.equals(MatchStatus.class)) {
            isValid = null != MatchStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, MatchStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ApplyInvalidFlag.class)) {
            isValid = null != ApplyInvalidFlag.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ApplyInvalidFlag.class.getSimpleName());
            }
        }
        if(clazz.equals(SystemOrigType.class)) {
            isValid = null != SystemOrigType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, SystemOrigType.class.getSimpleName());
            }
        }
        if(clazz.equals(AuditStatus.class)) {
            isValid = null != AuditStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, AuditStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(BillAuthStatus.class)) {
            isValid = null != BillAuthStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, BillAuthStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(IsNeedAuth.class)) {
            isValid = null != IsNeedAuth.fromCode(value);
            if(!isValid) {
                unValidMsg(context, IsNeedAuth.class.getSimpleName());
            }
        }
        if(clazz.equals(BillRecogStatus.class)) {
            isValid = null != BillRecogStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, BillRecogStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(AutoCheckStatus.class)) {
            isValid = null != AutoCheckStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, AutoCheckStatus.class.getSimpleName());
            }
        }

        return isValid;
    }

    private void unValidMsg(ConstraintValidatorContext context, String enumName){
        context.disableDefaultConstraintViolation();
        context.buildConstraintViolationWithTemplate(
                String.format(MSG_FORMAT, enumName))
                .addConstraintViolation();
    }
}
