package com.xforceplus.ultraman.app.jcvankepurchaser.metadata.validator;

import com.xforceplus.ultraman.app.jcvankepurchaser.metadata.validator.annotation.CheckUltramanEnums;

import com.xforceplus.ultraman.app.jcvankepurchaser.metadata.dict.*;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import java.util.Arrays;
import java.util.List;

/**
 * <p>
 * UltramanEnumsConstraintValidator
 * </p>
 *
 * @author ultraman
 * @since 2023-09-26
 */
public class UltramanEnumsConstraintValidator implements ConstraintValidator<CheckUltramanEnums, String> {

    private final String MSG_FORMAT = "value must be formed from codes of enum %s";

    Class clazz;

    @Override
    public void initialize(CheckUltramanEnums constraintAnnotation) {
        clazz = constraintAnnotation.value();
    }

    @Override
    public boolean isValid(String value, ConstraintValidatorContext context) {
        if(null == value || value.length() == 0) {
            return true;
        }

        boolean isValid = true;
        List<String> vals = Arrays.asList(value.split(","));

        if(clazz.equals(FlowStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != FlowStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, FlowStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(SnapshotFormat.class)) {
            isValid = vals.stream()
                    .filter(val -> null != SnapshotFormat.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, SnapshotFormat.class.getSimpleName());
            }
        }
        if(clazz.equals(CompanyRoleType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != CompanyRoleType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, CompanyRoleType.class.getSimpleName());
            }
        }
        if(clazz.equals(DataFromSystem.class)) {
            isValid = vals.stream()
                    .filter(val -> null != DataFromSystem.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, DataFromSystem.class.getSimpleName());
            }
        }
        if(clazz.equals(IsSynergetics.class)) {
            isValid = vals.stream()
                    .filter(val -> null != IsSynergetics.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, IsSynergetics.class.getSimpleName());
            }
        }
        if(clazz.equals(ApplyModifyType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ApplyModifyType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ApplyModifyType.class.getSimpleName());
            }
        }
        if(clazz.equals(AuditState.class)) {
            isValid = vals.stream()
                    .filter(val -> null != AuditState.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, AuditState.class.getSimpleName());
            }
        }
        if(clazz.equals(LegalPersonDataSources.class)) {
            isValid = vals.stream()
                    .filter(val -> null != LegalPersonDataSources.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, LegalPersonDataSources.class.getSimpleName());
            }
        }
        if(clazz.equals(IsOverDued.class)) {
            isValid = vals.stream()
                    .filter(val -> null != IsOverDued.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, IsOverDued.class.getSimpleName());
            }
        }
        if(clazz.equals(BusinessSource.class)) {
            isValid = vals.stream()
                    .filter(val -> null != BusinessSource.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, BusinessSource.class.getSimpleName());
            }
        }
        if(clazz.equals(YesOrNo.class)) {
            isValid = vals.stream()
                    .filter(val -> null != YesOrNo.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, YesOrNo.class.getSimpleName());
            }
        }
        if(clazz.equals(IsVoucherCreated.class)) {
            isValid = vals.stream()
                    .filter(val -> null != IsVoucherCreated.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, IsVoucherCreated.class.getSimpleName());
            }
        }
        if(clazz.equals(CanDeduction.class)) {
            isValid = vals.stream()
                    .filter(val -> null != CanDeduction.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, CanDeduction.class.getSimpleName());
            }
        }
        if(clazz.equals(BillInvoiceStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != BillInvoiceStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, BillInvoiceStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(OrderAuthStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != OrderAuthStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, OrderAuthStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(CompareStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != CompareStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, CompareStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(OrderStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != OrderStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, OrderStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(CooperateFlag.class)) {
            isValid = vals.stream()
                    .filter(val -> null != CooperateFlag.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, CooperateFlag.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != InvoiceType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, InvoiceType.class.getSimpleName());
            }
        }
        if(clazz.equals(TaskStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != TaskStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, TaskStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(TodoTaskTopic.class)) {
            isValid = vals.stream()
                    .filter(val -> null != TodoTaskTopic.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, TodoTaskTopic.class.getSimpleName());
            }
        }
        if(clazz.equals(SubscriberName.class)) {
            isValid = vals.stream()
                    .filter(val -> null != SubscriberName.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, SubscriberName.class.getSimpleName());
            }
        }
        if(clazz.equals(OrderError.class)) {
            isValid = vals.stream()
                    .filter(val -> null != OrderError.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, OrderError.class.getSimpleName());
            }
        }
        if(clazz.equals(OrderInvoiceType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != OrderInvoiceType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, OrderInvoiceType.class.getSimpleName());
            }
        }
        if(clazz.equals(DayOfWeek.class)) {
            isValid = vals.stream()
                    .filter(val -> null != DayOfWeek.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, DayOfWeek.class.getSimpleName());
            }
        }
        if(clazz.equals(RecalculationStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != RecalculationStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, RecalculationStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(TimeType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != TimeType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, TimeType.class.getSimpleName());
            }
        }
        if(clazz.equals(DataType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != DataType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, DataType.class.getSimpleName());
            }
        }
        if(clazz.equals(CompareMessage.class)) {
            isValid = vals.stream()
                    .filter(val -> null != CompareMessage.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, CompareMessage.class.getSimpleName());
            }
        }
        if(clazz.equals(StuckReason.class)) {
            isValid = vals.stream()
                    .filter(val -> null != StuckReason.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, StuckReason.class.getSimpleName());
            }
        }
        if(clazz.equals(ExceptionType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ExceptionType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ExceptionType.class.getSimpleName());
            }
        }
        if(clazz.equals(IsQualified.class)) {
            isValid = vals.stream()
                    .filter(val -> null != IsQualified.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, IsQualified.class.getSimpleName());
            }
        }
        if(clazz.equals(CooperateFlag1693983864680.class)) {
            isValid = vals.stream()
                    .filter(val -> null != CooperateFlag1693983864680.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, CooperateFlag1693983864680.class.getSimpleName());
            }
        }
        if(clazz.equals(BusinessBillType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != BusinessBillType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, BusinessBillType.class.getSimpleName());
            }
        }
        if(clazz.equals(BillInvoiceType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != BillInvoiceType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, BillInvoiceType.class.getSimpleName());
            }
        }
        if(clazz.equals(PriceMethod.class)) {
            isValid = vals.stream()
                    .filter(val -> null != PriceMethod.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, PriceMethod.class.getSimpleName());
            }
        }
        if(clazz.equals(TaxInvoiceSource.class)) {
            isValid = vals.stream()
                    .filter(val -> null != TaxInvoiceSource.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, TaxInvoiceSource.class.getSimpleName());
            }
        }
        if(clazz.equals(ReceiptType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ReceiptType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ReceiptType.class.getSimpleName());
            }
        }
        if(clazz.equals(UsingStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != UsingStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, UsingStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(CooperateModifyStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != CooperateModifyStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, CooperateModifyStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(BillStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != BillStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, BillStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(MakeoutStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != MakeoutStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, MakeoutStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(UploadConfirmFlag.class)) {
            isValid = vals.stream()
                    .filter(val -> null != UploadConfirmFlag.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, UploadConfirmFlag.class.getSimpleName());
            }
        }
        if(clazz.equals(ReceiveConfirmFlag.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ReceiveConfirmFlag.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ReceiveConfirmFlag.class.getSimpleName());
            }
        }
        if(clazz.equals(PurchaserType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != PurchaserType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, PurchaserType.class.getSimpleName());
            }
        }
        if(clazz.equals(MakingReason.class)) {
            isValid = vals.stream()
                    .filter(val -> null != MakingReason.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, MakingReason.class.getSimpleName());
            }
        }
        if(clazz.equals(MatchStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != MatchStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, MatchStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ApplyInvalidFlag.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ApplyInvalidFlag.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ApplyInvalidFlag.class.getSimpleName());
            }
        }
        if(clazz.equals(SystemOrigType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != SystemOrigType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, SystemOrigType.class.getSimpleName());
            }
        }
        if(clazz.equals(AuditStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != AuditStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, AuditStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(BillAuthStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != BillAuthStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, BillAuthStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(IsNeedAuth.class)) {
            isValid = vals.stream()
                    .filter(val -> null != IsNeedAuth.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, IsNeedAuth.class.getSimpleName());
            }
        }
        if(clazz.equals(BillRecogStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != BillRecogStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, BillRecogStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(AutoCheckStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != AutoCheckStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, AutoCheckStatus.class.getSimpleName());
            }
        }

        return isValid;
    }

    private void unValidMsg(ConstraintValidatorContext context, String enumName){
        context.disableDefaultConstraintViolation();
        context.buildConstraintViolationWithTemplate(
                        String.format(MSG_FORMAT, enumName))
                .addConstraintViolation();
    }
}
