package com.xforceplus.ultraman.app.jcvankepurchaser.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jcvankepurchaser.entity.EmailTodoTask;
import com.xforceplus.ultraman.app.jcvankepurchaser.service.IEmailTodoTaskService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-08-31
 */
@RestController
public class EmailTodoTaskController {

  @Autowired
  private IEmailTodoTaskService emailTodoTaskServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param emailTodoTask ${table.comment}
   * @return
   */
  @GetMapping("/emailtodotasks" )
  public XfR getEmailTodoTasks(XfPage page, EmailTodoTask emailTodoTask) {
    return XfR.ok(emailTodoTaskServiceImpl.page(page, Wrappers.query(emailTodoTask)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/emailtodotasks/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(emailTodoTaskServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param emailTodoTask ${table.comment}
   * @return XfR
   */
  @PostMapping("/emailtodotasks")
  public XfR save(@RequestBody EmailTodoTask emailTodoTask) {
     return XfR.ok(emailTodoTaskServiceImpl.save(emailTodoTask));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param emailTodoTask ${table.comment}
   * @return XfR
   */
  @PutMapping("/emailtodotasks/{id}")
  public XfR putUpdate(@RequestBody EmailTodoTask emailTodoTask,@PathVariable Long id) {
      emailTodoTask.setId(id);
      return XfR.ok(emailTodoTaskServiceImpl.updateById(emailTodoTask));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param emailTodoTask ${table.comment}
   * @return XfR
   */
  @PatchMapping("/emailtodotasks/{id}")
  public XfR patchUpdate(@RequestBody EmailTodoTask emailTodoTask,@PathVariable Long id) {
      EmailTodoTask upemailTodoTask = emailTodoTaskServiceImpl.getById(id);
      if(upemailTodoTask != null){
        upemailTodoTask = ObjectCopyUtils.copyProperties(emailTodoTask,upemailTodoTask,true);
      }
      return XfR.ok(emailTodoTaskServiceImpl.updateById(upemailTodoTask));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/emailtodotasks/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(emailTodoTaskServiceImpl.removeById(id));
  }

  @PostMapping("/emailtodotasks/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "email_todo_task");
     params.put("request", condition);

     return XfR.ok(emailTodoTaskServiceImpl.querys(params));
  }

}
