package com.xforceplus.ultraman.app.jcvankepurchaser.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jcvankepurchaser.entity.PilotTaxNo;
import com.xforceplus.ultraman.app.jcvankepurchaser.service.IPilotTaxNoService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-08-31
 */
@RestController
public class PilotTaxNoController {

  @Autowired
  private IPilotTaxNoService pilotTaxNoServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param pilotTaxNo ${table.comment}
   * @return
   */
  @GetMapping("/pilottaxnos" )
  public XfR getPilotTaxNos(XfPage page, PilotTaxNo pilotTaxNo) {
    return XfR.ok(pilotTaxNoServiceImpl.page(page, Wrappers.query(pilotTaxNo)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/pilottaxnos/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(pilotTaxNoServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param pilotTaxNo ${table.comment}
   * @return XfR
   */
  @PostMapping("/pilottaxnos")
  public XfR save(@RequestBody PilotTaxNo pilotTaxNo) {
     return XfR.ok(pilotTaxNoServiceImpl.save(pilotTaxNo));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param pilotTaxNo ${table.comment}
   * @return XfR
   */
  @PutMapping("/pilottaxnos/{id}")
  public XfR putUpdate(@RequestBody PilotTaxNo pilotTaxNo,@PathVariable Long id) {
      pilotTaxNo.setId(id);
      return XfR.ok(pilotTaxNoServiceImpl.updateById(pilotTaxNo));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param pilotTaxNo ${table.comment}
   * @return XfR
   */
  @PatchMapping("/pilottaxnos/{id}")
  public XfR patchUpdate(@RequestBody PilotTaxNo pilotTaxNo,@PathVariable Long id) {
      PilotTaxNo uppilotTaxNo = pilotTaxNoServiceImpl.getById(id);
      if(uppilotTaxNo != null){
        uppilotTaxNo = ObjectCopyUtils.copyProperties(pilotTaxNo,uppilotTaxNo,true);
      }
      return XfR.ok(pilotTaxNoServiceImpl.updateById(uppilotTaxNo));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/pilottaxnos/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(pilotTaxNoServiceImpl.removeById(id));
  }

  @PostMapping("/pilottaxnos/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "pilot_tax_no");
     params.put("request", condition);

     return XfR.ok(pilotTaxNoServiceImpl.querys(params));
  }

}
