package com.xforceplus.ultraman.app.jcvankepurchaser.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jcvankepurchaser.entity.UserPerformance;
import com.xforceplus.ultraman.app.jcvankepurchaser.service.IUserPerformanceService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-08-31
 */
@RestController
public class UserPerformanceController {

  @Autowired
  private IUserPerformanceService userPerformanceServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param userPerformance ${table.comment}
   * @return
   */
  @GetMapping("/userperformances" )
  public XfR getUserPerformances(XfPage page, UserPerformance userPerformance) {
    return XfR.ok(userPerformanceServiceImpl.page(page, Wrappers.query(userPerformance)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/userperformances/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(userPerformanceServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param userPerformance ${table.comment}
   * @return XfR
   */
  @PostMapping("/userperformances")
  public XfR save(@RequestBody UserPerformance userPerformance) {
     return XfR.ok(userPerformanceServiceImpl.save(userPerformance));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param userPerformance ${table.comment}
   * @return XfR
   */
  @PutMapping("/userperformances/{id}")
  public XfR putUpdate(@RequestBody UserPerformance userPerformance,@PathVariable Long id) {
      userPerformance.setId(id);
      return XfR.ok(userPerformanceServiceImpl.updateById(userPerformance));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param userPerformance ${table.comment}
   * @return XfR
   */
  @PatchMapping("/userperformances/{id}")
  public XfR patchUpdate(@RequestBody UserPerformance userPerformance,@PathVariable Long id) {
      UserPerformance upuserPerformance = userPerformanceServiceImpl.getById(id);
      if(upuserPerformance != null){
        upuserPerformance = ObjectCopyUtils.copyProperties(userPerformance,upuserPerformance,true);
      }
      return XfR.ok(userPerformanceServiceImpl.updateById(upuserPerformance));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/userperformances/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(userPerformanceServiceImpl.removeById(id));
  }

  @PostMapping("/userperformances/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "user_performance");
     params.put("request", condition);

     return XfR.ok(userPerformanceServiceImpl.querys(params));
  }

}
