package com.xforceplus.ultraman.app.jcvankepurchaser.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jcvankepurchaser.entity.OrdersEndcheck;
import com.xforceplus.ultraman.app.jcvankepurchaser.service.IOrdersEndcheckService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 报表前端控制器
 *
 * @author ultraman
 * @date 2024-02-28
 */
@RestController
public class OrdersEndcheckController {

  @Autowired
  private IOrdersEndcheckService ordersEndcheckServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param ordersEndcheck 报表
   * @return
   */
  @GetMapping("/ordersendchecks" )
  public XfR getOrdersEndchecks(XfPage page, OrdersEndcheck ordersEndcheck) {
    return XfR.ok(ordersEndcheckServiceImpl.page(page, Wrappers.query(ordersEndcheck)));
  }

  /**
   * 通过id查询报表
   * @param  id
   * @return XfR
   */
  @GetMapping("/ordersendchecks/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(ordersEndcheckServiceImpl.getById(id));
  }

  /**
   * 新增报表
   * @param ordersEndcheck 报表
   * @return XfR
   */
  @PostMapping("/ordersendchecks")
  public XfR save(@RequestBody OrdersEndcheck ordersEndcheck) {
     return XfR.ok(ordersEndcheckServiceImpl.save(ordersEndcheck));
  }

  /**
   * 修改-传入修改后的全部数据报表
   * @param ordersEndcheck 报表
   * @return XfR
   */
  @PutMapping("/ordersendchecks/{id}")
  public XfR putUpdate(@RequestBody OrdersEndcheck ordersEndcheck,@PathVariable Long id) {
      ordersEndcheck.setId(id);
      return XfR.ok(ordersEndcheckServiceImpl.updateById(ordersEndcheck));
  }

  /**
   * 修改-传入修改的数据报表
   * @param ordersEndcheck 报表
   * @return XfR
   */
  @PatchMapping("/ordersendchecks/{id}")
  public XfR patchUpdate(@RequestBody OrdersEndcheck ordersEndcheck,@PathVariable Long id) {
      OrdersEndcheck upordersEndcheck = ordersEndcheckServiceImpl.getById(id);
      if(upordersEndcheck != null){
        upordersEndcheck = ObjectCopyUtils.copyProperties(ordersEndcheck,upordersEndcheck,true);
      }
      return XfR.ok(ordersEndcheckServiceImpl.updateById(upordersEndcheck));
  }

  /**
   * 通过id删除报表
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/ordersendchecks/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(ordersEndcheckServiceImpl.removeById(id));
  }

  @PostMapping("/ordersendchecks/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "orders_endcheck");
     params.put("request", condition);

     return XfR.ok(ordersEndcheckServiceImpl.querys(params));
  }

}
