package com.xforceplus.ultraman.app.jcvankepurchaser.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jcvankepurchaser.entity.SapBusinessSystemsLog;
import com.xforceplus.ultraman.app.jcvankepurchaser.service.ISapBusinessSystemsLogService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-02-28
 */
@RestController
public class SapBusinessSystemsLogController {

  @Autowired
  private ISapBusinessSystemsLogService sapBusinessSystemsLogServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param sapBusinessSystemsLog ${table.comment}
   * @return
   */
  @GetMapping("/sapbusinesssystemslogs" )
  public XfR getSapBusinessSystemsLogs(XfPage page, SapBusinessSystemsLog sapBusinessSystemsLog) {
    return XfR.ok(sapBusinessSystemsLogServiceImpl.page(page, Wrappers.query(sapBusinessSystemsLog)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/sapbusinesssystemslogs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(sapBusinessSystemsLogServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param sapBusinessSystemsLog ${table.comment}
   * @return XfR
   */
  @PostMapping("/sapbusinesssystemslogs")
  public XfR save(@RequestBody SapBusinessSystemsLog sapBusinessSystemsLog) {
     return XfR.ok(sapBusinessSystemsLogServiceImpl.save(sapBusinessSystemsLog));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param sapBusinessSystemsLog ${table.comment}
   * @return XfR
   */
  @PutMapping("/sapbusinesssystemslogs/{id}")
  public XfR putUpdate(@RequestBody SapBusinessSystemsLog sapBusinessSystemsLog,@PathVariable Long id) {
      sapBusinessSystemsLog.setId(id);
      return XfR.ok(sapBusinessSystemsLogServiceImpl.updateById(sapBusinessSystemsLog));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param sapBusinessSystemsLog ${table.comment}
   * @return XfR
   */
  @PatchMapping("/sapbusinesssystemslogs/{id}")
  public XfR patchUpdate(@RequestBody SapBusinessSystemsLog sapBusinessSystemsLog,@PathVariable Long id) {
      SapBusinessSystemsLog upsapBusinessSystemsLog = sapBusinessSystemsLogServiceImpl.getById(id);
      if(upsapBusinessSystemsLog != null){
        upsapBusinessSystemsLog = ObjectCopyUtils.copyProperties(sapBusinessSystemsLog,upsapBusinessSystemsLog,true);
      }
      return XfR.ok(sapBusinessSystemsLogServiceImpl.updateById(upsapBusinessSystemsLog));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/sapbusinesssystemslogs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(sapBusinessSystemsLogServiceImpl.removeById(id));
  }

  @PostMapping("/sapbusinesssystemslogs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "sap_business_systems_log");
     params.put("request", condition);

     return XfR.ok(sapBusinessSystemsLogServiceImpl.querys(params));
  }

}
