package com.xforceplus.ultraman.app.jcvankepurchaser.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jcvankepurchaser.entity.StuckOrder;
import com.xforceplus.ultraman.app.jcvankepurchaser.service.IStuckOrderService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 报表前端控制器
 *
 * @author ultraman
 * @date 2024-02-28
 */
@RestController
public class StuckOrderController {

  @Autowired
  private IStuckOrderService stuckOrderServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param stuckOrder 报表
   * @return
   */
  @GetMapping("/stuckorders" )
  public XfR getStuckOrders(XfPage page, StuckOrder stuckOrder) {
    return XfR.ok(stuckOrderServiceImpl.page(page, Wrappers.query(stuckOrder)));
  }

  /**
   * 通过id查询报表
   * @param  id
   * @return XfR
   */
  @GetMapping("/stuckorders/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(stuckOrderServiceImpl.getById(id));
  }

  /**
   * 新增报表
   * @param stuckOrder 报表
   * @return XfR
   */
  @PostMapping("/stuckorders")
  public XfR save(@RequestBody StuckOrder stuckOrder) {
     return XfR.ok(stuckOrderServiceImpl.save(stuckOrder));
  }

  /**
   * 修改-传入修改后的全部数据报表
   * @param stuckOrder 报表
   * @return XfR
   */
  @PutMapping("/stuckorders/{id}")
  public XfR putUpdate(@RequestBody StuckOrder stuckOrder,@PathVariable Long id) {
      stuckOrder.setId(id);
      return XfR.ok(stuckOrderServiceImpl.updateById(stuckOrder));
  }

  /**
   * 修改-传入修改的数据报表
   * @param stuckOrder 报表
   * @return XfR
   */
  @PatchMapping("/stuckorders/{id}")
  public XfR patchUpdate(@RequestBody StuckOrder stuckOrder,@PathVariable Long id) {
      StuckOrder upstuckOrder = stuckOrderServiceImpl.getById(id);
      if(upstuckOrder != null){
        upstuckOrder = ObjectCopyUtils.copyProperties(stuckOrder,upstuckOrder,true);
      }
      return XfR.ok(stuckOrderServiceImpl.updateById(upstuckOrder));
  }

  /**
   * 通过id删除报表
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/stuckorders/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(stuckOrderServiceImpl.removeById(id));
  }

  @PostMapping("/stuckorders/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "stuck_order");
     params.put("request", condition);

     return XfR.ok(stuckOrderServiceImpl.querys(params));
  }

}
