package com.xforceplus.ultraman.app.jcvankepurchaser.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jcvankepurchaser.entity.LegalPersonResume;
import com.xforceplus.ultraman.app.jcvankepurchaser.service.ILegalPersonResumeService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-08-17
 */
@RestController
public class LegalPersonResumeController {

  @Autowired
  private ILegalPersonResumeService legalPersonResumeServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param legalPersonResume ${table.comment}
   * @return
   */
  @GetMapping("/legalpersonresumes" )
  public XfR getLegalPersonResumes(XfPage page, LegalPersonResume legalPersonResume) {
    return XfR.ok(legalPersonResumeServiceImpl.page(page, Wrappers.query(legalPersonResume)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/legalpersonresumes/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(legalPersonResumeServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param legalPersonResume ${table.comment}
   * @return XfR
   */
  @PostMapping("/legalpersonresumes")
  public XfR save(@RequestBody LegalPersonResume legalPersonResume) {
     return XfR.ok(legalPersonResumeServiceImpl.save(legalPersonResume));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param legalPersonResume ${table.comment}
   * @return XfR
   */
  @PutMapping("/legalpersonresumes/{id}")
  public XfR putUpdate(@RequestBody LegalPersonResume legalPersonResume,@PathVariable Long id) {
      legalPersonResume.setId(id);
      return XfR.ok(legalPersonResumeServiceImpl.updateById(legalPersonResume));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param legalPersonResume ${table.comment}
   * @return XfR
   */
  @PatchMapping("/legalpersonresumes/{id}")
  public XfR patchUpdate(@RequestBody LegalPersonResume legalPersonResume,@PathVariable Long id) {
      LegalPersonResume uplegalPersonResume = legalPersonResumeServiceImpl.getById(id);
      if(uplegalPersonResume != null){
        uplegalPersonResume = ObjectCopyUtils.copyProperties(legalPersonResume,uplegalPersonResume,true);
      }
      return XfR.ok(legalPersonResumeServiceImpl.updateById(uplegalPersonResume));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/legalpersonresumes/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(legalPersonResumeServiceImpl.removeById(id));
  }

  @PostMapping("/legalpersonresumes/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "legal_person_resume");
     params.put("request", condition);

     return XfR.ok(legalPersonResumeServiceImpl.querys(params));
  }

}
