package com.xforceplus.ultraman.app.jcvankepurchaser.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jcvankepurchaser.entity.OrderErrorStatement;
import com.xforceplus.ultraman.app.jcvankepurchaser.service.IOrderErrorStatementService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-08-17
 */
@RestController
public class OrderErrorStatementController {

  @Autowired
  private IOrderErrorStatementService orderErrorStatementServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param orderErrorStatement ${table.comment}
   * @return
   */
  @GetMapping("/ordererrorstatements" )
  public XfR getOrderErrorStatements(XfPage page, OrderErrorStatement orderErrorStatement) {
    return XfR.ok(orderErrorStatementServiceImpl.page(page, Wrappers.query(orderErrorStatement)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/ordererrorstatements/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(orderErrorStatementServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param orderErrorStatement ${table.comment}
   * @return XfR
   */
  @PostMapping("/ordererrorstatements")
  public XfR save(@RequestBody OrderErrorStatement orderErrorStatement) {
     return XfR.ok(orderErrorStatementServiceImpl.save(orderErrorStatement));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param orderErrorStatement ${table.comment}
   * @return XfR
   */
  @PutMapping("/ordererrorstatements/{id}")
  public XfR putUpdate(@RequestBody OrderErrorStatement orderErrorStatement,@PathVariable Long id) {
      orderErrorStatement.setId(id);
      return XfR.ok(orderErrorStatementServiceImpl.updateById(orderErrorStatement));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param orderErrorStatement ${table.comment}
   * @return XfR
   */
  @PatchMapping("/ordererrorstatements/{id}")
  public XfR patchUpdate(@RequestBody OrderErrorStatement orderErrorStatement,@PathVariable Long id) {
      OrderErrorStatement uporderErrorStatement = orderErrorStatementServiceImpl.getById(id);
      if(uporderErrorStatement != null){
        uporderErrorStatement = ObjectCopyUtils.copyProperties(orderErrorStatement,uporderErrorStatement,true);
      }
      return XfR.ok(orderErrorStatementServiceImpl.updateById(uporderErrorStatement));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/ordererrorstatements/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(orderErrorStatementServiceImpl.removeById(id));
  }

  @PostMapping("/ordererrorstatements/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "order_error_statement");
     params.put("request", condition);

     return XfR.ok(orderErrorStatementServiceImpl.querys(params));
  }

}
