package com.xforceplus.ultraman.app.jcvankeshare2.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 操作状态
 * </p>
 *
 * @author ultraman
 * @since 2023-02-13
 */
public enum OpeartStatusEnum {

    _0("0", "成功"),
    __1("-1", "失败");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    OpeartStatusEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static OpeartStatusEnum fromCode(String code) {
        return Stream.of(OpeartStatusEnum.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
