package com.xforceplus.ultraman.app.jcvankeshare2.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 组织类型的枚举
 * </p>
 *
 * @author ultraman
 * @since 2023-02-13
 */
public enum OrgTypeEnum {

    _1("1", "公司（COMPANY）"),
    _0("0", "组织（GROUP）");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    OrgTypeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static OrgTypeEnum fromCode(String code) {
        return Stream.of(OrgTypeEnum.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
