package com.xforceplus.ultraman.app.jcvankeshare2.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 封锁与解锁状态的枚举值
 * </p>
 *
 * @author ultraman
 * @since 2023-02-13
 */
public enum StatusEnum {

    _0("0", "解锁"),
    _1("1", "封锁");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    StatusEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static StatusEnum fromCode(String code) {
        return Stream.of(StatusEnum.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
