package com.xforceplus.ultraman.app.jcvankeshare2.metadata.validator;

import com.xforceplus.ultraman.app.jcvankeshare2.metadata.dict.*;
import com.xforceplus.ultraman.app.jcvankeshare2.metadata.validator.annotation.*;

import org.hibernate.validator.HibernateValidator;
import org.hibernate.validator.HibernateValidatorConfiguration;
import org.hibernate.validator.cfg.ConstraintMapping;
import org.hibernate.validator.cfg.GenericConstraintDef;
import org.hibernate.validator.cfg.defs.*;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.executable.ExecutableValidator;
import javax.validation.metadata.BeanDescriptor;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * <p>
 * UltramanMetadataValidator
 * </p>
 *
 * @author ultraman
 * @since 2023-02-13
 */
public class EntityMetaValidator implements Validator {

    private Validator validator;

    public EntityMetaValidator() {
        HibernateValidatorConfiguration configuration = Validation
                .byProvider(HibernateValidator.class)
                .configure();

        ConstraintMapping constraintMapping = configuration.createConstraintMapping();

        buildConstraintMapping(constraintMapping);

        this.validator = configuration.addMapping(constraintMapping)
                .buildValidatorFactory()
                .getValidator();
    }

    public <T> Set<ConstraintViolation<T>> validateProperties(T object, String ...propertyNames) {
        return Arrays.asList(propertyNames).stream()
                .map(propertyName -> validator.validateProperty(object, propertyName))
                .flatMap(Collection::stream)
                .collect(Collectors.toSet());
    }

    @Override
    public <T> Set<ConstraintViolation<T>> validate(T object, Class<?>... groups) {
        return validator.validate(object, groups);
    }

    @Override
    public <T> Set<ConstraintViolation<T>> validateProperty(T object, String propertyName, Class<?>... groups) {
        return validator.validateProperty(object, propertyName, groups);
    }

    @Override
    public <T> Set<ConstraintViolation<T>> validateValue(Class<T> beanType, String propertyName, Object value, Class<?>... groups) {
        return validator.validateValue(beanType, propertyName, value, groups);
    }

    @Override
    public BeanDescriptor getConstraintsForClass(Class<?> clazz) {
        return validator.getConstraintsForClass(clazz);
    }

    @Override
    public <T> T unwrap(Class<T> type) {
        return validator.unwrap(type);
    }

    @Override
    public ExecutableValidator forExecutables() {
        return validator.forExecutables();
    }

    private void buildConstraintMapping(ConstraintMapping constraintMapping) {

        // org_entity
        constraintMapping
            .type(com.xforceplus.ultraman.app.jcvankeshare2.metadata.entity.OrgEntity.class)
            .field("orgId")
            .constraint(new LengthDef().min(0).max(20))
            .field("id")
            .field("tenantId")
            .field("tenantCode")
            .field("createTime")
            .field("updateTime")
            .field("createUserId")
            .field("updateUserId")
            .field("createUserName")
            .field("updateUserName")
            .field("deleteFlag")
            .field("orgCode")
            .constraint(new LengthDef().min(0).max(20))
            .field("orgName")
            .constraint(new LengthDef().min(0).max(20))
            .field("orgNameEqual")
            .constraint(new LengthDef().min(0).max(20))
            .field("companyId")
            .constraint(new LengthDef().min(0).max(20))
            .field("parentId")
            .constraint(new LengthDef().min(0).max(20))
            .field("orgType")
            .constraint(new LengthDef().min(0).max(4))
            .constraint(new GenericConstraintDef<>(CheckUltramanEnum.class).param("value", OrgTypeEnum.class))
            .field("companyCode")
            .constraint(new LengthDef().min(0).max(20))
            .field("companyName")
            .constraint(new LengthDef().min(0).max(20))
            .field("status")
            .constraint(new LengthDef().min(0).max(4))
            .constraint(new GenericConstraintDef<>(CheckUltramanEnum.class).param("value", StatusEnum.class))
            .field("tenantName")
            .constraint(new LengthDef().min(0).max(20))
            .field("userId")
            .constraint(new LengthDef().min(0).max(20))
            .field("userName")
            .constraint(new LengthDef().min(0).max(20))
            .field("taxNum")
            .constraint(new LengthDef().min(0).max(30))
            ;
        // org_entity_opeart_log
        constraintMapping
            .type(com.xforceplus.ultraman.app.jcvankeshare2.metadata.entity.OrgEntityOpeartLog.class)
            .field("operator")
            .constraint(new LengthDef().min(0).max(20))
            .field("msgId")
            .constraint(new LengthDef().min(0).max(40))
            .field("operatResult")
            .constraint(new LengthDef().min(0).max(100))
            .field("id")
            .field("tenantId")
            .field("tenantCode")
            .field("createTime")
            .field("updateTime")
            .field("createUserId")
            .field("updateUserId")
            .field("createUserName")
            .field("updateUserName")
            .field("deleteFlag")
            .field("orgEntityId")
            .constraint(new LengthDef().min(0).max(20))
            .field("orgEntityStatus")
            .constraint(new LengthDef().min(0).max(4))
            .constraint(new GenericConstraintDef<>(CheckUltramanEnum.class).param("value", StatusEnum.class))
            .field("status")
            .constraint(new LengthDef().min(0).max(4))
            .constraint(new GenericConstraintDef<>(CheckUltramanEnum.class).param("value", OpeartStatusEnum.class))
            ;
        // system_log
        constraintMapping
            .type(com.xforceplus.ultraman.app.jcvankeshare2.metadata.entity.SystemLog.class)
            .field("methodName")
            .constraint(new LengthDef().min(0).max(100))
            .field("message")
            .constraint(new LengthDef().min(0).max(2000))
            .field("id")
            .field("tenantId")
            .field("tenantCode")
            .field("createTime")
            .field("updateTime")
            .field("createUserId")
            .field("updateUserId")
            .field("createUserName")
            .field("updateUserName")
            .field("deleteFlag")
            .field("msgId")
            .constraint(new LengthDef().min(0).max(40))
            .field("level")
            .constraint(new LengthDef().min(0).max(20))
            .field("threadName")
            .constraint(new LengthDef().min(0).max(100))
            .field("timeStamp")
            .constraint(new LengthDef().min(0).max(20))
            ;
        // method_operat_log
        constraintMapping
            .type(com.xforceplus.ultraman.app.jcvankeshare2.metadata.entity.MethodOperatLog.class)
            .field("methodName")
            .constraint(new LengthDef().min(0).max(100))
            .field("executeTime")
            .constraint(new LengthDef().min(0).max(20))
            .field("createTime")
            .constraint(new LengthDef().min(0).max(20))
            .field("parameters")
            .constraint(new LengthDef().min(0).max(20))
            .field("results")
            .constraint(new LengthDef().min(0).max(20))
            .field("id")
            .field("tenantId")
            .field("tenantCode")
            .field("updateTime")
            .field("createUserId")
            .field("updateUserId")
            .field("createUserName")
            .field("updateUserName")
            .field("deleteFlag")
            .field("msgId")
            .constraint(new LengthDef().min(0).max(40))
            ;
    }
}
