package com.xforceplus.ultraman.app.jcvankeshare2.metadata.validator;

import com.xforceplus.ultraman.app.jcvankeshare2.metadata.validator.annotation.CheckUltramanEnum;

import com.xforceplus.ultraman.app.jcvankeshare2.metadata.dict.*;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

/**
 * <p>
 * UltramanEnumConstraintValidator
 * </p>
 *
 * @author ultraman
 * @since 2023-02-13
 */
public class UltramanEnumConstraintValidator implements ConstraintValidator<CheckUltramanEnum, String> {

    private final String MSG_FORMAT = "value must be the code of one of enum %s";

    Class clazz;

    @Override
    public void initialize(CheckUltramanEnum constraintAnnotation) {
        clazz = constraintAnnotation.value();
    }

    @Override
    public boolean isValid(String value, ConstraintValidatorContext context) {
        if(null == value || value.length() == 0) {
            return true;
        }

        boolean isValid = true;

        if(clazz.equals(OpeartStatusEnum.class)) {
            isValid = null != OpeartStatusEnum.fromCode(value);
            if(!isValid) {
                unValidMsg(context, OpeartStatusEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(OrgTypeEnum.class)) {
            isValid = null != OrgTypeEnum.fromCode(value);
            if(!isValid) {
                unValidMsg(context, OrgTypeEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(StatusEnum.class)) {
            isValid = null != StatusEnum.fromCode(value);
            if(!isValid) {
                unValidMsg(context, StatusEnum.class.getSimpleName());
            }
        }

        return isValid;
    }

    private void unValidMsg(ConstraintValidatorContext context, String enumName){
        context.disableDefaultConstraintViolation();
        context.buildConstraintViolationWithTemplate(
                String.format(MSG_FORMAT, enumName))
                .addConstraintViolation();
    }
}
