package com.xforceplus.ultraman.app.jcwatsons.controller;


/**
 * 发票表feign客户端
 *
 * @author ultraman
 * @date 2023-04-25
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jcwatsons.entity.Invoice;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-watsons")
public interface InvoiceFeignApi {

  /**
   * 通过id查询发票表
   * @param  id
   * @return R
   */
  @GetMapping("/invoice/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增发票表
   * @param invoice 发票表
   * @return R
   */
  @PostMapping("/invoice/add")
  public R save(@RequestBody Invoice invoice);

  /**
   * 修改发票表
   * @param invoice 发票表
   * @return R
   */
  @PostMapping("/invoice/update")
  public R updateById(@RequestBody Invoice invoice);

  /**
   * 通过id删除发票表
   * @param  id
   * @return R
   */
  @DeleteMapping("/invoice/del/{id}" )
  public R removeById(@PathVariable Long id);

}