package com.xforceplus.ultraman.app.jcwatsons.controller;


/**
 * ${table.comment}feign客户端
 *
 * @author ultraman
 * @date 2023-05-11
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jcwatsons.entity.AccountManger;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-watsons")
public interface AccountMangerFeignApi {

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return R
   */
  @GetMapping("/accountManger/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增${table.comment}
   * @param accountManger ${table.comment}
   * @return R
   */
  @PostMapping("/accountManger/add")
  public R save(@RequestBody AccountManger accountManger);

  /**
   * 修改${table.comment}
   * @param accountManger ${table.comment}
   * @return R
   */
  @PostMapping("/accountManger/update")
  public R updateById(@RequestBody AccountManger accountManger);

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return R
   */
  @DeleteMapping("/accountManger/del/{id}" )
  public R removeById(@PathVariable Long id);

}