package com.xforceplus.ultraman.app.jcwatsons.controller;


/**
 * 测试一下feign客户端
 *
 * @author ultraman
 * @date 2023-05-11
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jcwatsons.entity.Test111;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-watsons")
public interface Test111FeignApi {

  /**
   * 通过id查询测试一下
   * @param  id
   * @return R
   */
  @GetMapping("/test111/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增测试一下
   * @param test111 测试一下
   * @return R
   */
  @PostMapping("/test111/add")
  public R save(@RequestBody Test111 test111);

  /**
   * 修改测试一下
   * @param test111 测试一下
   * @return R
   */
  @PostMapping("/test111/update")
  public R updateById(@RequestBody Test111 test111);

  /**
   * 通过id删除测试一下
   * @param  id
   * @return R
   */
  @DeleteMapping("/test111/del/{id}" )
  public R removeById(@PathVariable Long id);

}