package com.xforceplus.ultraman.app.jcwatsons.controller;


/**
 * 各来源发票记账记录feign客户端
 *
 * @author ultraman
 * @date 2024-08-30
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jcwatsons.entity.AffirmInvoice;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-watsons")
public interface AffirmInvoiceFeignApi {

  /**
   * 通过id查询各来源发票记账记录
   * @param  id
   * @return R
   */
  @GetMapping("/affirmInvoice/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增各来源发票记账记录
   * @param affirmInvoice 各来源发票记账记录
   * @return R
   */
  @PostMapping("/affirmInvoice/add")
  public R save(@RequestBody AffirmInvoice affirmInvoice);

  /**
   * 修改各来源发票记账记录
   * @param affirmInvoice 各来源发票记账记录
   * @return R
   */
  @PostMapping("/affirmInvoice/update")
  public R updateById(@RequestBody AffirmInvoice affirmInvoice);

  /**
   * 通过id删除各来源发票记账记录
   * @param  id
   * @return R
   */
  @DeleteMapping("/affirmInvoice/del/{id}" )
  public R removeById(@PathVariable Long id);

}