package com.xforceplus.ultraman.app.jcwatsons.controller;


/**
 * ${table.comment}feign客户端
 *
 * @author ultraman
 * @date 2024-08-30
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jcwatsons.entity.ApplyGroupObj;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-watsons")
public interface ApplyGroupObjFeignApi {

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return R
   */
  @GetMapping("/applyGroupObj/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增${table.comment}
   * @param applyGroupObj ${table.comment}
   * @return R
   */
  @PostMapping("/applyGroupObj/add")
  public R save(@RequestBody ApplyGroupObj applyGroupObj);

  /**
   * 修改${table.comment}
   * @param applyGroupObj ${table.comment}
   * @return R
   */
  @PostMapping("/applyGroupObj/update")
  public R updateById(@RequestBody ApplyGroupObj applyGroupObj);

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return R
   */
  @DeleteMapping("/applyGroupObj/del/{id}" )
  public R removeById(@PathVariable Long id);

}