package com.xforceplus.ultraman.app.jcwatsons.controller;


/**
 * ${table.comment}feign客户端
 *
 * @author ultraman
 * @date 2024-08-30
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jcwatsons.entity.AttachmentManage;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-watsons")
public interface AttachmentManageFeignApi {

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return R
   */
  @GetMapping("/attachmentManage/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增${table.comment}
   * @param attachmentManage ${table.comment}
   * @return R
   */
  @PostMapping("/attachmentManage/add")
  public R save(@RequestBody AttachmentManage attachmentManage);

  /**
   * 修改${table.comment}
   * @param attachmentManage ${table.comment}
   * @return R
   */
  @PostMapping("/attachmentManage/update")
  public R updateById(@RequestBody AttachmentManage attachmentManage);

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return R
   */
  @DeleteMapping("/attachmentManage/del/{id}" )
  public R removeById(@PathVariable Long id);

}