package com.xforceplus.ultraman.app.jcwatsons.controller;


/**
 * 提交审批的对象feign客户端
 *
 * @author ultraman
 * @date 2024-08-30
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jcwatsons.entity.ExamineObj;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-watsons")
public interface ExamineObjFeignApi {

  /**
   * 通过id查询提交审批的对象
   * @param  id
   * @return R
   */
  @GetMapping("/examineObj/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增提交审批的对象
   * @param examineObj 提交审批的对象
   * @return R
   */
  @PostMapping("/examineObj/add")
  public R save(@RequestBody ExamineObj examineObj);

  /**
   * 修改提交审批的对象
   * @param examineObj 提交审批的对象
   * @return R
   */
  @PostMapping("/examineObj/update")
  public R updateById(@RequestBody ExamineObj examineObj);

  /**
   * 通过id删除提交审批的对象
   * @param  id
   * @return R
   */
  @DeleteMapping("/examineObj/del/{id}" )
  public R removeById(@PathVariable Long id);

}