package com.xforceplus.ultraman.app.jcwatsons.controller;


/**
 * 从FTP同步过来的MKT开票原数据feign客户端
 *
 * @author ultraman
 * @date 2024-08-30
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jcwatsons.entity.MktSalesData;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-watsons")
public interface MktSalesDataFeignApi {

  /**
   * 通过id查询从FTP同步过来的MKT开票原数据
   * @param  id
   * @return R
   */
  @GetMapping("/mktSalesData/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增从FTP同步过来的MKT开票原数据
   * @param mktSalesData 从FTP同步过来的MKT开票原数据
   * @return R
   */
  @PostMapping("/mktSalesData/add")
  public R save(@RequestBody MktSalesData mktSalesData);

  /**
   * 修改从FTP同步过来的MKT开票原数据
   * @param mktSalesData 从FTP同步过来的MKT开票原数据
   * @return R
   */
  @PostMapping("/mktSalesData/update")
  public R updateById(@RequestBody MktSalesData mktSalesData);

  /**
   * 通过id删除从FTP同步过来的MKT开票原数据
   * @param  id
   * @return R
   */
  @DeleteMapping("/mktSalesData/del/{id}" )
  public R removeById(@PathVariable Long id);

}