package com.xforceplus.ultraman.app.jcwatsons.controller;


/**
 * ${table.comment}feign客户端
 *
 * @author ultraman
 * @date 2024-08-30
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jcwatsons.entity.RedLetterClaimPool;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-watsons")
public interface RedLetterClaimPoolFeignApi {

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return R
   */
  @GetMapping("/redLetterClaimPool/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增${table.comment}
   * @param redLetterClaimPool ${table.comment}
   * @return R
   */
  @PostMapping("/redLetterClaimPool/add")
  public R save(@RequestBody RedLetterClaimPool redLetterClaimPool);

  /**
   * 修改${table.comment}
   * @param redLetterClaimPool ${table.comment}
   * @return R
   */
  @PostMapping("/redLetterClaimPool/update")
  public R updateById(@RequestBody RedLetterClaimPool redLetterClaimPool);

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return R
   */
  @DeleteMapping("/redLetterClaimPool/del/{id}" )
  public R removeById(@PathVariable Long id);

}