package com.xforceplus.ultraman.app.jcwatsons.controller;


/**
 * feign客户端
 *
 * @author ultraman
 * @date 2024-08-30
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jcwatsons.entity.SalesBillDetail;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-watsons")
public interface SalesBillDetailFeignApi {

  /**
   * 通过id查询
   * @param  id
   * @return R
   */
  @GetMapping("/salesBillDetail/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增
   * @param salesBillDetail 
   * @return R
   */
  @PostMapping("/salesBillDetail/add")
  public R save(@RequestBody SalesBillDetail salesBillDetail);

  /**
   * 修改
   * @param salesBillDetail 
   * @return R
   */
  @PostMapping("/salesBillDetail/update")
  public R updateById(@RequestBody SalesBillDetail salesBillDetail);

  /**
   * 通过id删除
   * @param  id
   * @return R
   */
  @DeleteMapping("/salesBillDetail/del/{id}" )
  public R removeById(@PathVariable Long id);

}