package com.xforceplus.ultraman.app.jcwatsons.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * affirm_channel
 * </p>
 *
 * @author ultraman
 * @since 2025-12-02
 */
public enum AffirmChannel {

    _1("1", "汇联易移交"),
    _2("2", "租赁系统移交"),
    _3("3", "手工导入"),
    _4("4", "影像采集"),
    _5("5", "风险发票池"),
    _6("6", "海关缴款书"),
    _7("7", "红字进转出"),
    _8("8", "SNC移交");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    AffirmChannel(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static AffirmChannel fromCode(String code){
        switch(code) {
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            case "5":
                return _5;
            case "6":
                return _6;
            case "7":
                return _7;
            case "8":
                return _8;
            default:
                return null;
        }
    }
}
