package com.xforceplus.ultraman.app.jcwatsons.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * audit_status
 * </p>
 *
 * @author ultraman
 * @since 2025-12-02
 */
public enum AuditStatus {

    _2("2", "已审核"),
    _0("0", "驳回"),
    _1("1", "正常");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    AuditStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static AuditStatus fromCode(String code){
        switch(code) {
            case "2":
                return _2;
            case "0":
                return _0;
            case "1":
                return _1;
            default:
                return null;
        }
    }
}
