package com.xforceplus.ultraman.app.jcwatsons.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * end_type
 * </p>
 *
 * @author ultraman
 * @since 2025-12-02
 */
public enum EndType {

    _01("01", "完结"),
    _02("02", "作废申请单");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    EndType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static EndType fromCode(String code){
        switch(code) {
            case "01":
                return _01;
            case "02":
                return _02;
            default:
                return null;
        }
    }
}
