package com.xforceplus.ultraman.app.jcwatsons.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * examine_status
 * </p>
 *
 * @author ultraman
 * @since 2025-12-02
 */
public enum ExamineStatus {

    _01("01", "通过"),
    _02("02", "驳回"),
    _03("03", "申请成功"),
    _04("04", "申请失败"),
    _05("05", "撤销成功"),
    _06("06", "撤销失败"),
    _07("07", "上传税局"),
    _08("08", "同步结果"),
    _00("00", "默认"),
    _09("09", "创建成功"),
    _10("10", "创建失败"),
    _11("11", "业务单作废成功"),
    _12("12", "业务单作废失败");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    ExamineStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ExamineStatus fromCode(String code){
        switch(code) {
            case "01":
                return _01;
            case "02":
                return _02;
            case "03":
                return _03;
            case "04":
                return _04;
            case "05":
                return _05;
            case "06":
                return _06;
            case "07":
                return _07;
            case "08":
                return _08;
            case "00":
                return _00;
            case "09":
                return _09;
            case "10":
                return _10;
            case "11":
                return _11;
            case "12":
                return _12;
            default:
                return null;
        }
    }
}
