package com.xforceplus.ultraman.app.jcwatsons.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * invoice_source
 * </p>
 *
 * @author ultraman
 * @since 2025-12-02
 */
public enum InvoiceSource {

    _1("1", "4.0 平台"),
    _2("2", "3.0 平台"),
    _3("3", "税件低频"),
    _4("4", "税件归集"),
    _9("9", "其他");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    InvoiceSource(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static InvoiceSource fromCode(String code){
        switch(code) {
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            case "9":
                return _9;
            default:
                return null;
        }
    }
}
