package com.xforceplus.ultraman.app.jcwatsons.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * redflush_workflow_type
 * </p>
 *
 * @author ultraman
 * @since 2025-12-02
 */
public enum RedFlushWorkflowType {

    _01("01", "红字信息表申请"),
    _02("02", "红字信息表撤销申请"),
    _03("03", "红字确认单申请"),
    _04("04", "红字确认单撤销申请"),
    _05("05", "业务单开票申请"),
    _06("06", "发票作废申请"),
    _07("07", "普票红冲申请"),
    _08("08", "信息表红冲申请");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    RedFlushWorkflowType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static RedFlushWorkflowType fromCode(String code){
        switch(code) {
            case "01":
                return _01;
            case "02":
                return _02;
            case "03":
                return _03;
            case "04":
                return _04;
            case "05":
                return _05;
            case "06":
                return _06;
            case "07":
                return _07;
            case "08":
                return _08;
            default:
                return null;
        }
    }
}
