package com.xforceplus.ultraman.app.jcwatsons.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * red_letter_from
 * </p>
 *
 * @author ultraman
 * @since 2025-12-02
 */
public enum RedLetterFrom {

    _0("0", "未知"),
    _1("1", "4.0"),
    _2("2", "协同"),
    _3("3", "3.0");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    RedLetterFrom(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static RedLetterFrom fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            default:
                return null;
        }
    }
}
