package com.xforceplus.ultraman.app.jcwatsons.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * sales_bill_status
 * </p>
 *
 * @author ultraman
 * @since 2025-12-02
 */
public enum SalesBillStatus {

    _01("01", "待提交"),
    _02("02", "待审批"),
    _03("03", "待复核"),
    _04("04", "待开票"),
    _05("05", "已开票"),
    _06("06", "已作废"),
    _07("07", "不予上传"),
    _08("08", "其他");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    SalesBillStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static SalesBillStatus fromCode(String code){
        switch(code) {
            case "01":
                return _01;
            case "02":
                return _02;
            case "03":
                return _03;
            case "04":
                return _04;
            case "05":
                return _05;
            case "06":
                return _06;
            case "07":
                return _07;
            case "08":
                return _08;
            default:
                return null;
        }
    }
}
