package com.xforceplus.ultraman.app.jcwatsons.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * tmcs_red_type
 * </p>
 *
 * @author ultraman
 * @since 2025-12-02
 */
public enum TmcsRedType {

    _01("01", "红字信息表"),
    _02("02", "红字确认单");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    TmcsRedType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static TmcsRedType fromCode(String code){
        switch(code) {
            case "01":
                return _01;
            case "02":
                return _02;
            default:
                return null;
        }
    }
}
