package com.xforceplus.ultraman.app.jcwatsons.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2025-12-02
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class ExamineManage implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 申请单类型
   */
  @TableField("workflowType")
  private String workflowType;

  /**
   * 销方名称
   */
  @TableField("sellerName")
  private String sellerName;

  /**
   * 销方税号
   */
  @TableField("sellerTaxNo")
  private String sellerTaxNo;

  /**
   * 购方名称
   */
  @TableField("buyerName")
  private String buyerName;

  /**
   * 购方税号
   */
  @TableField("buyerTaxNo")
  private String buyerTaxNo;

  /**
   * 申请人员
   */
  @TableField("applyUser")
  private String applyUser;

  /**
   * 申请时间
   */
  @TableField("applyTime")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime applyTime;

  /**
   * 申请说明
   */
  @TableField("applyReason")
  private String applyReason;

  /**
   * 流程状态
   */
  @TableField("workflowStatus")
  private String workflowStatus;

  /**
   * 完结类型
   */
  @TableField("endType")
  private String endType;

  /**
   * 完结备注
   */
  @TableField("endRemark")
  private String endRemark;

  /**
   * 上传失败原因
   */
  @TableField("uploadFailReason")
  private String uploadFailReason;

  /**
   * 审核人
   */
  @TableField("auditingUser")
  private String auditingUser;

  /**
   * 审核时间
   */
  @TableField("auditingTime")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime auditingTime;

  /**
   * 复核人
   */
  @TableField("examineUser")
  private String examineUser;

  /**
   * 复核时间
   */
  @TableField("examineTime")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime examineTime;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 历史红字确认单编号
   */
  @TableField("historyRedLetterNumber")
  private String historyRedLetterNumber;

  /**
   * 导入批次号
   */
  @TableField("applyBatchNum")
  private String applyBatchNum;

  /**
   * 申请人ID
   */
  @TableField("applyUserId")
  private Long applyUserId;

  /**
   * 审核人ID
   */
  @TableField("auditingUserId")
  private Long auditingUserId;

  /**
   * 复核人ID
   */
  @TableField("examineUserId")
  private Long examineUserId;

  /**
   * 审核人邮箱
   */
  @TableField("auditingUserEmail")
  private String auditingUserEmail;

  /**
   * 复核人邮箱
   */
  @TableField("examineUserEmail")
  private String examineUserEmail;

  /**
   * 申请人组别
   */
  @TableField("applyGroup")
  private String applyGroup;

  /**
   * 复核人组别
   */
  @TableField("examineGroup")
  private String examineGroup;

  /**
   * 申请人邮箱
   */
  @TableField("applyUserEmail")
  private String applyUserEmail;

  /**
   * 申请单编号
   */
  @TableField("applyNo")
  private String applyNo;

  /**
   * 税局受理日期
   */
  @TableField("taxAcceptDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime taxAcceptDate;

  /**
   * 含税金额
   */
  @TableField("amountWithTax")
  private BigDecimal amountWithTax;

  /**
   * 不含税金额
   */
  @TableField("amountWithoutTax")
  private BigDecimal amountWithoutTax;

  /**
   * 税额
   */
  @TableField("taxAmount")
  private BigDecimal taxAmount;

  /**
   * 账户类型
   */
  @TableField("accountType")
  private String accountType;

  /**
   * 对应红字业务单号
   */
  @TableField("salesbillNo")
  private String salesbillNo;

  /**
   * 审批流来源
   */
  @TableField("workFlowSource")
  private String workFlowSource;

  /**
   * 订单号
   */
  @TableField("orderNo")
  private String orderNo;

  /**
   * 邮件发送时间
   */
  @TableField("emailSendTime")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime emailSendTime;

  /**
   * 组织树
   */
  private String orgTree;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("workflowType", workflowType);
      map.put("sellerName", sellerName);
      map.put("sellerTaxNo", sellerTaxNo);
      map.put("buyerName", buyerName);
      map.put("buyerTaxNo", buyerTaxNo);
      map.put("applyUser", applyUser);
      map.put("applyTime", BocpGenUtils.toTimestamp(applyTime));
      map.put("applyReason", applyReason);
      map.put("workflowStatus", workflowStatus);
      map.put("endType", endType);
      map.put("endRemark", endRemark);
      map.put("uploadFailReason", uploadFailReason);
      map.put("auditingUser", auditingUser);
      map.put("auditingTime", BocpGenUtils.toTimestamp(auditingTime));
      map.put("examineUser", examineUser);
      map.put("examineTime", BocpGenUtils.toTimestamp(examineTime));
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("historyRedLetterNumber", historyRedLetterNumber);
      map.put("applyBatchNum", applyBatchNum);
      map.put("applyUserId", applyUserId);
      map.put("auditingUserId", auditingUserId);
      map.put("examineUserId", examineUserId);
      map.put("auditingUserEmail", auditingUserEmail);
      map.put("examineUserEmail", examineUserEmail);
      map.put("applyGroup", applyGroup);
      map.put("examineGroup", examineGroup);
      map.put("applyUserEmail", applyUserEmail);
      map.put("applyNo", applyNo);
      map.put("taxAcceptDate", BocpGenUtils.toTimestamp(taxAcceptDate));
      map.put("amountWithTax", amountWithTax);
      map.put("amountWithoutTax", amountWithoutTax);
      map.put("taxAmount", taxAmount);
      map.put("accountType", accountType);
      map.put("salesbillNo", salesbillNo);
      map.put("workFlowSource", workFlowSource);
      map.put("orderNo", orderNo);
      map.put("emailSendTime", BocpGenUtils.toTimestamp(emailSendTime));
      map.put("org_tree", orgTree);

      return map;
  }

  public static ExamineManage fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    ExamineManage entity = new ExamineManage();
    if(map.containsKey("workflowType")) {
      Object obj = map.get("workflowType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setWorkflowType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerName")) {
      Object obj = map.get("sellerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerTaxNo")) {
      Object obj = map.get("sellerTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyerName")) {
      Object obj = map.get("buyerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBuyerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyerTaxNo")) {
      Object obj = map.get("buyerTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBuyerTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("applyUser")) {
      Object obj = map.get("applyUser");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setApplyUser((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("applyTime")) {
      Object obj = map.get("applyTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setApplyTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setApplyTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setApplyTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setApplyTime(null);
      }
    }
    if(map.containsKey("applyReason")) {
      Object obj = map.get("applyReason");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setApplyReason((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("workflowStatus")) {
      Object obj = map.get("workflowStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setWorkflowStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("endType")) {
      Object obj = map.get("endType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setEndType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("endRemark")) {
      Object obj = map.get("endRemark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setEndRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("uploadFailReason")) {
      Object obj = map.get("uploadFailReason");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUploadFailReason((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("auditingUser")) {
      Object obj = map.get("auditingUser");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAuditingUser((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("auditingTime")) {
      Object obj = map.get("auditingTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setAuditingTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setAuditingTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAuditingTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setAuditingTime(null);
      }
    }
    if(map.containsKey("examineUser")) {
      Object obj = map.get("examineUser");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExamineUser((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("examineTime")) {
      Object obj = map.get("examineTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setExamineTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setExamineTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setExamineTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setExamineTime(null);
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("historyRedLetterNumber")) {
      Object obj = map.get("historyRedLetterNumber");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setHistoryRedLetterNumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("applyBatchNum")) {
      Object obj = map.get("applyBatchNum");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setApplyBatchNum((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("applyUserId")) {
      Object obj = map.get("applyUserId");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setApplyUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setApplyUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setApplyUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("auditingUserId")) {
      Object obj = map.get("auditingUserId");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setAuditingUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAuditingUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAuditingUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("examineUserId")) {
      Object obj = map.get("examineUserId");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setExamineUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setExamineUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setExamineUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("auditingUserEmail")) {
      Object obj = map.get("auditingUserEmail");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAuditingUserEmail((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("examineUserEmail")) {
      Object obj = map.get("examineUserEmail");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExamineUserEmail((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("applyGroup")) {
      Object obj = map.get("applyGroup");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setApplyGroup((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("examineGroup")) {
      Object obj = map.get("examineGroup");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExamineGroup((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("applyUserEmail")) {
      Object obj = map.get("applyUserEmail");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setApplyUserEmail((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("applyNo")) {
      Object obj = map.get("applyNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setApplyNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxAcceptDate")) {
      Object obj = map.get("taxAcceptDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTaxAcceptDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setTaxAcceptDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTaxAcceptDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setTaxAcceptDate(null);
      }
    }
    if(map.containsKey("amountWithTax")) {
      Object obj = map.get("amountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("amountWithoutTax")) {
      Object obj = map.get("amountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("taxAmount")) {
      Object obj = map.get("taxAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("accountType")) {
      Object obj = map.get("accountType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAccountType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("salesbillNo")) {
      Object obj = map.get("salesbillNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSalesbillNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("workFlowSource")) {
      Object obj = map.get("workFlowSource");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setWorkFlowSource((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("orderNo")) {
      Object obj = map.get("orderNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrderNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("emailSendTime")) {
      Object obj = map.get("emailSendTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setEmailSendTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setEmailSendTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setEmailSendTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setEmailSendTime(null);
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrgTree((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("workflowType")) {
      Object obj = map.get("workflowType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setWorkflowType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerName")) {
      Object obj = map.get("sellerName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerTaxNo")) {
      Object obj = map.get("sellerTaxNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerTaxNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("buyerName")) {
      Object obj = map.get("buyerName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBuyerName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("buyerTaxNo")) {
      Object obj = map.get("buyerTaxNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBuyerTaxNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("applyUser")) {
      Object obj = map.get("applyUser");
      if(obj != null) {
        if(obj instanceof String) {
          this.setApplyUser((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("applyTime")) {
      Object obj = map.get("applyTime");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setApplyTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setApplyTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setApplyTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setApplyTime(null);
      }
    }
    if(map.containsKey("applyReason")) {
      Object obj = map.get("applyReason");
      if(obj != null) {
        if(obj instanceof String) {
          this.setApplyReason((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("workflowStatus")) {
      Object obj = map.get("workflowStatus");
      if(obj != null) {
        if(obj instanceof String) {
          this.setWorkflowStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("endType")) {
      Object obj = map.get("endType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setEndType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("endRemark")) {
      Object obj = map.get("endRemark");
      if(obj != null) {
        if(obj instanceof String) {
          this.setEndRemark((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("uploadFailReason")) {
      Object obj = map.get("uploadFailReason");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUploadFailReason((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("auditingUser")) {
      Object obj = map.get("auditingUser");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAuditingUser((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("auditingTime")) {
      Object obj = map.get("auditingTime");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setAuditingTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setAuditingTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setAuditingTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setAuditingTime(null);
      }
    }
    if(map.containsKey("examineUser")) {
      Object obj = map.get("examineUser");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExamineUser((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("examineTime")) {
      Object obj = map.get("examineTime");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setExamineTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setExamineTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setExamineTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setExamineTime(null);
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("historyRedLetterNumber")) {
      Object obj = map.get("historyRedLetterNumber");
      if(obj != null) {
        if(obj instanceof String) {
          this.setHistoryRedLetterNumber((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("applyBatchNum")) {
      Object obj = map.get("applyBatchNum");
      if(obj != null) {
        if(obj instanceof String) {
          this.setApplyBatchNum((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("applyUserId")) {
      Object obj = map.get("applyUserId");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setApplyUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setApplyUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setApplyUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("auditingUserId")) {
      Object obj = map.get("auditingUserId");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setAuditingUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setAuditingUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setAuditingUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("examineUserId")) {
      Object obj = map.get("examineUserId");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setExamineUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setExamineUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setExamineUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("auditingUserEmail")) {
      Object obj = map.get("auditingUserEmail");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAuditingUserEmail((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("examineUserEmail")) {
      Object obj = map.get("examineUserEmail");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExamineUserEmail((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("applyGroup")) {
      Object obj = map.get("applyGroup");
      if(obj != null) {
        if(obj instanceof String) {
          this.setApplyGroup((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("examineGroup")) {
      Object obj = map.get("examineGroup");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExamineGroup((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("applyUserEmail")) {
      Object obj = map.get("applyUserEmail");
      if(obj != null) {
        if(obj instanceof String) {
          this.setApplyUserEmail((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("applyNo")) {
      Object obj = map.get("applyNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setApplyNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("taxAcceptDate")) {
      Object obj = map.get("taxAcceptDate");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTaxAcceptDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setTaxAcceptDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTaxAcceptDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setTaxAcceptDate(null);
      }
    }
    if(map.containsKey("amountWithTax")) {
      Object obj = map.get("amountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("amountWithoutTax")) {
      Object obj = map.get("amountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("taxAmount")) {
      Object obj = map.get("taxAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("accountType")) {
      Object obj = map.get("accountType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAccountType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("salesbillNo")) {
      Object obj = map.get("salesbillNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSalesbillNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("workFlowSource")) {
      Object obj = map.get("workFlowSource");
      if(obj != null) {
        if(obj instanceof String) {
          this.setWorkFlowSource((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("orderNo")) {
      Object obj = map.get("orderNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrderNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("emailSendTime")) {
      Object obj = map.get("emailSendTime");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setEmailSendTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setEmailSendTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setEmailSendTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setEmailSendTime(null);
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrgTree((String)obj);
        }
      } else {
      }
    }
  }
}
