package com.xforceplus.ultraman.app.jcwatsons.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2025-12-02
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class OfflineRedLetterReport implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 申请单类型
   */
  @TableField("workflowType")
  private String workflowType;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 申请时间
   */
  @TableField("applyTime")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime applyTime;

  /**
   * 申请撤销时间
   */
  @TableField("applyCancelTime")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime applyCancelTime;

  /**
   * 所属部门
   */
  @TableField("functionGroup")
  private String functionGroup;

  /**
   * 购货方名称
   */
  @TableField("buyerName")
  private String buyerName;

  /**
   * 销货方名称
   */
  @TableField("sellerName")
  private String sellerName;

  /**
   * 申请金额（不含税）
   */
  @TableField("applyAmountWithoutTax")
  private BigDecimal applyAmountWithoutTax;

  /**
   * 填表人
   */
  @TableField("applyUser")
  private String applyUser;

  /**
   * 审核人
   */
  @TableField("examineUser")
  private String examineUser;

  /**
   * 对应蓝字发票是否已认证
   */
  @TableField("authStatus")
  private String authStatus;

  /**
   * 原蓝票发票代码
   */
  @TableField("originalInvoiceCode")
  private String originalInvoiceCode;

  /**
   * 原蓝票发票号码
   */
  @TableField("originalInvoiceNo")
  private String originalInvoiceNo;

  /**
   * 税局受理日期
   */
  @TableField("taxAcceptTime")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime taxAcceptTime;

  /**
   * 红字发票通知单编号
   */
  @TableField("applyTaxNo")
  private String applyTaxNo;

  /**
   * 通知单不含税金额
   */
  @TableField("amountWithoutTax")
  private BigDecimal amountWithoutTax;

  /**
   * 通知单税额
   */
  @TableField("taxAmount")
  private BigDecimal taxAmount;

  /**
   * 通知单状态
   */
  @TableField("infomationApplyStatus")
  private String infomationApplyStatus;

  /**
   * 红字发票收回日期
   */
  @TableField("redRecoveryDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime redRecoveryDate;

  /**
   * 红字发票代码
   */
  @TableField("redInvoiceCode")
  private String redInvoiceCode;

  /**
   * 红字发票号码
   */
  @TableField("redInvoiceNo")
  private String redInvoiceNo;

  /**
   * 红字发票税额
   */
  @TableField("redTaxAmount")
  private BigDecimal redTaxAmount;

  /**
   * 红字发票价税合计
   */
  @TableField("redAmountWithTax")
  private BigDecimal redAmountWithTax;

  /**
   * 红字发票不含税金额
   */
  @TableField("redAmountWithoutTax")
  private BigDecimal redAmountWithoutTax;

  /**
   * 红字发票开票日期
   */
  @TableField("redPaperDrewDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime redPaperDrewDate;

  /**
   * 税局撤销时间
   */
  @TableField("taxCancelTime")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime taxCancelTime;

  /**
   * 购货方jv
   */
  @TableField("jvCode")
  private String jvCode;

  /**
   * 组织树
   */
  private String orgTree;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("workflowType", workflowType);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("applyTime", BocpGenUtils.toTimestamp(applyTime));
      map.put("applyCancelTime", BocpGenUtils.toTimestamp(applyCancelTime));
      map.put("functionGroup", functionGroup);
      map.put("buyerName", buyerName);
      map.put("sellerName", sellerName);
      map.put("applyAmountWithoutTax", applyAmountWithoutTax);
      map.put("applyUser", applyUser);
      map.put("examineUser", examineUser);
      map.put("authStatus", authStatus);
      map.put("originalInvoiceCode", originalInvoiceCode);
      map.put("originalInvoiceNo", originalInvoiceNo);
      map.put("taxAcceptTime", BocpGenUtils.toTimestamp(taxAcceptTime));
      map.put("applyTaxNo", applyTaxNo);
      map.put("amountWithoutTax", amountWithoutTax);
      map.put("taxAmount", taxAmount);
      map.put("infomationApplyStatus", infomationApplyStatus);
      map.put("redRecoveryDate", BocpGenUtils.toTimestamp(redRecoveryDate));
      map.put("redInvoiceCode", redInvoiceCode);
      map.put("redInvoiceNo", redInvoiceNo);
      map.put("redTaxAmount", redTaxAmount);
      map.put("redAmountWithTax", redAmountWithTax);
      map.put("redAmountWithoutTax", redAmountWithoutTax);
      map.put("redPaperDrewDate", BocpGenUtils.toTimestamp(redPaperDrewDate));
      map.put("taxCancelTime", BocpGenUtils.toTimestamp(taxCancelTime));
      map.put("jvCode", jvCode);
      map.put("org_tree", orgTree);

      return map;
  }

  public static OfflineRedLetterReport fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    OfflineRedLetterReport entity = new OfflineRedLetterReport();
    if(map.containsKey("workflowType")) {
      Object obj = map.get("workflowType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setWorkflowType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("applyTime")) {
      Object obj = map.get("applyTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setApplyTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setApplyTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setApplyTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setApplyTime(null);
      }
    }
    if(map.containsKey("applyCancelTime")) {
      Object obj = map.get("applyCancelTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setApplyCancelTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setApplyCancelTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setApplyCancelTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setApplyCancelTime(null);
      }
    }
    if(map.containsKey("functionGroup")) {
      Object obj = map.get("functionGroup");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setFunctionGroup((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyerName")) {
      Object obj = map.get("buyerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBuyerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerName")) {
      Object obj = map.get("sellerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("applyAmountWithoutTax")) {
      Object obj = map.get("applyAmountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setApplyAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setApplyAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setApplyAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setApplyAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setApplyAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("applyUser")) {
      Object obj = map.get("applyUser");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setApplyUser((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("examineUser")) {
      Object obj = map.get("examineUser");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExamineUser((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("authStatus")) {
      Object obj = map.get("authStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAuthStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("originalInvoiceCode")) {
      Object obj = map.get("originalInvoiceCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOriginalInvoiceCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("originalInvoiceNo")) {
      Object obj = map.get("originalInvoiceNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOriginalInvoiceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxAcceptTime")) {
      Object obj = map.get("taxAcceptTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTaxAcceptTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setTaxAcceptTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTaxAcceptTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setTaxAcceptTime(null);
      }
    }
    if(map.containsKey("applyTaxNo")) {
      Object obj = map.get("applyTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setApplyTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("amountWithoutTax")) {
      Object obj = map.get("amountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("taxAmount")) {
      Object obj = map.get("taxAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("infomationApplyStatus")) {
      Object obj = map.get("infomationApplyStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInfomationApplyStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("redRecoveryDate")) {
      Object obj = map.get("redRecoveryDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setRedRecoveryDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setRedRecoveryDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setRedRecoveryDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setRedRecoveryDate(null);
      }
    }
    if(map.containsKey("redInvoiceCode")) {
      Object obj = map.get("redInvoiceCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRedInvoiceCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("redInvoiceNo")) {
      Object obj = map.get("redInvoiceNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRedInvoiceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("redTaxAmount")) {
      Object obj = map.get("redTaxAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setRedTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setRedTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setRedTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setRedTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setRedTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("redAmountWithTax")) {
      Object obj = map.get("redAmountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setRedAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setRedAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setRedAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setRedAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setRedAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("redAmountWithoutTax")) {
      Object obj = map.get("redAmountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setRedAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setRedAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setRedAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setRedAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setRedAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("redPaperDrewDate")) {
      Object obj = map.get("redPaperDrewDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setRedPaperDrewDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setRedPaperDrewDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setRedPaperDrewDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setRedPaperDrewDate(null);
      }
    }
    if(map.containsKey("taxCancelTime")) {
      Object obj = map.get("taxCancelTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTaxCancelTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setTaxCancelTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTaxCancelTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setTaxCancelTime(null);
      }
    }
    if(map.containsKey("jvCode")) {
      Object obj = map.get("jvCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setJvCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrgTree((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("workflowType")) {
      Object obj = map.get("workflowType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setWorkflowType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("applyTime")) {
      Object obj = map.get("applyTime");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setApplyTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setApplyTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setApplyTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setApplyTime(null);
      }
    }
    if(map.containsKey("applyCancelTime")) {
      Object obj = map.get("applyCancelTime");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setApplyCancelTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setApplyCancelTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setApplyCancelTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setApplyCancelTime(null);
      }
    }
    if(map.containsKey("functionGroup")) {
      Object obj = map.get("functionGroup");
      if(obj != null) {
        if(obj instanceof String) {
          this.setFunctionGroup((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("buyerName")) {
      Object obj = map.get("buyerName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBuyerName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerName")) {
      Object obj = map.get("sellerName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("applyAmountWithoutTax")) {
      Object obj = map.get("applyAmountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setApplyAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setApplyAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setApplyAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setApplyAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setApplyAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("applyUser")) {
      Object obj = map.get("applyUser");
      if(obj != null) {
        if(obj instanceof String) {
          this.setApplyUser((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("examineUser")) {
      Object obj = map.get("examineUser");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExamineUser((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("authStatus")) {
      Object obj = map.get("authStatus");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAuthStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("originalInvoiceCode")) {
      Object obj = map.get("originalInvoiceCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOriginalInvoiceCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("originalInvoiceNo")) {
      Object obj = map.get("originalInvoiceNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOriginalInvoiceNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("taxAcceptTime")) {
      Object obj = map.get("taxAcceptTime");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTaxAcceptTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setTaxAcceptTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTaxAcceptTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setTaxAcceptTime(null);
      }
    }
    if(map.containsKey("applyTaxNo")) {
      Object obj = map.get("applyTaxNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setApplyTaxNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("amountWithoutTax")) {
      Object obj = map.get("amountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("taxAmount")) {
      Object obj = map.get("taxAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("infomationApplyStatus")) {
      Object obj = map.get("infomationApplyStatus");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInfomationApplyStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("redRecoveryDate")) {
      Object obj = map.get("redRecoveryDate");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setRedRecoveryDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setRedRecoveryDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setRedRecoveryDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setRedRecoveryDate(null);
      }
    }
    if(map.containsKey("redInvoiceCode")) {
      Object obj = map.get("redInvoiceCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRedInvoiceCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("redInvoiceNo")) {
      Object obj = map.get("redInvoiceNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRedInvoiceNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("redTaxAmount")) {
      Object obj = map.get("redTaxAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setRedTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setRedTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setRedTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setRedTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setRedTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("redAmountWithTax")) {
      Object obj = map.get("redAmountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setRedAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setRedAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setRedAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setRedAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setRedAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("redAmountWithoutTax")) {
      Object obj = map.get("redAmountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setRedAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setRedAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setRedAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setRedAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setRedAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("redPaperDrewDate")) {
      Object obj = map.get("redPaperDrewDate");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setRedPaperDrewDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setRedPaperDrewDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setRedPaperDrewDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setRedPaperDrewDate(null);
      }
    }
    if(map.containsKey("taxCancelTime")) {
      Object obj = map.get("taxCancelTime");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTaxCancelTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setTaxCancelTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTaxCancelTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setTaxCancelTime(null);
      }
    }
    if(map.containsKey("jvCode")) {
      Object obj = map.get("jvCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setJvCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrgTree((String)obj);
        }
      } else {
      }
    }
  }
}
