package com.xforceplus.ultraman.app.jcwatsons.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2025-12-02
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class SalesBill implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 业务单号
   */
  @TableField("salesbillNo")
  private String salesbillNo;

  /**
   * 销方名称
   */
  @TableField("sellerName")
  private String sellerName;

  /**
   * 销方税号
   */
  @TableField("sellerTaxNo")
  private String sellerTaxNo;

  /**
   * 购方名称
   */
  @TableField("buyerName")
  private String buyerName;

  /**
   * 购方税号
   */
  @TableField("buyerTaxNo")
  private String buyerTaxNo;

  /**
   * 购方地址
   */
  @TableField("buyerAddress")
  private String buyerAddress;

  /**
   * 购方电话
   */
  @TableField("buyerTel")
  private String buyerTel;

  /**
   * 购方银行名称
   */
  @TableField("buyerBankName")
  private String buyerBankName;

  /**
   * 购方银行账号
   */
  @TableField("buyerBankAccount")
  private String buyerBankAccount;

  /**
   * 发票类型
   */
  @TableField("invoiceType")
  private String invoiceType;

  /**
   * 原始发票号码
   */
  @TableField("originalInvoiceNo")
  private String originalInvoiceNo;

  /**
   * 原始发票代码
   */
  @TableField("originalInvoiceCode")
  private String originalInvoiceCode;

  /**
   * 普票邮寄信息
   */
  @TableField("mailingInfo")
  private String mailingInfo;

  /**
   * 电票接收邮箱
   */
  private String emails;

  /**
   * 异常原因
   */
  @TableField("failReason")
  private String failReason;

  /**
   * 订单号
   */
  @TableField("orderRemark")
  private String orderRemark;

  /**
   * 备注
   */
  private String remark;

  /**
   * 红字编号
   */
  @TableField("redNo")
  private String redNo;

  /**
   * 业务单来源
   */
  private String srouce;

  /**
   * 作废原因
   */
  @TableField("abandonReason")
  private String abandonReason;

  /**
   * 组别信息
   */
  private String group;

  /**
   * 创建人
   */
  private String creator;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 申请人员
   */
  @TableField("applyUser")
  private String applyUser;

  /**
   * 申请人ID
   */
  @TableField("applyUserId")
  private String applyUserId;

  /**
   * 申请时间
   */
  @TableField("applyTime")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime applyTime;

  /**
   * 申请人邮箱
   */
  @TableField("applyUserEmail")
  private String applyUserEmail;

  /**
   * 复核人
   */
  @TableField("examineUser")
  private String examineUser;

  /**
   * 复核人ID
   */
  @TableField("examineUserId")
  private String examineUserId;

  /**
   * 复核人邮箱
   */
  @TableField("examineUserEmail")
  private String examineUserEmail;

  /**
   * 复核时间
   */
  @TableField("examineTime")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime examineTime;

  /**
   * 审核人
   */
  @TableField("auditingUser")
  private String auditingUser;

  /**
   * 审核人ID
   */
  @TableField("auditingUserId")
  private String auditingUserId;

  /**
   * 审核人邮箱
   */
  @TableField("auditingUserEmail")
  private String auditingUserEmail;

  /**
   * 审核时间
   */
  @TableField("auditingTime")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime auditingTime;

  /**
   * 税额
   */
  @TableField("taxAmount")
  private BigDecimal taxAmount;

  /**
   * 不含税金额
   */
  @TableField("amountWithoutTax")
  private BigDecimal amountWithoutTax;

  /**
   * 含税金额
   */
  @TableField("amountWithTax")
  private BigDecimal amountWithTax;

  /**
   * 开票申请单号
   */
  @TableField("applyNo")
  private String applyNo;

  /**
   * 业务单状态
   */
  @TableField("salesBillStatus")
  private String salesBillStatus;

  /**
   * 价格方式
   */
  @TableField("pricingMethod")
  private String pricingMethod;

  /**
   * 审核人组别
   */
  @TableField("auditingGroup")
  private String auditingGroup;

  /**
   * 上传失败原因
   */
  @TableField("uploadFailReason")
  private String uploadFailReason;

  /**
   * 合同编号
   */
  @TableField("contractNo")
  private String contractNo;

  /**
   * 其他说明
   */
  @TableField("otherReason")
  private String otherReason;

  /**
   * 内部交易类型
   */
  @TableField("internalType")
  private String internalType;

  /**
   * 业务单上传状态
   */
  @TableField("uploadStatus")
  private String uploadStatus;

  /**
   * 销方银行名称
   */
  @TableField("sellerBankName")
  private String sellerBankName;

  /**
   * 销方电话
   */
  @TableField("sellerTel")
  private String sellerTel;

  /**
   * 销方地址
   */
  @TableField("sellerAddress")
  private String sellerAddress;

  /**
   * 销方银行账号
   */
  @TableField("sellerBankAccount")
  private String sellerBankAccount;

  /**
   * 原开票日期
   */
  @TableField("originDateIssued")
  private String originDateIssued;

  /**
   * 原发票类型
   */
  @TableField("originInvoiceType")
  private String originInvoiceType;

  /**
   * 红冲原因
   */
  @TableField("reverseReason")
  private String reverseReason;

  /**
   * 申请人组别
   */
  @TableField("applyGroup")
  private String applyGroup;

  /**
   * 复核人组别
   */
  @TableField("examineGroup")
  private String examineGroup;

  /**
   * 申请说明
   */
  @TableField("appRemak")
  private String appRemak;

  /**
   * 开票员邮箱(多个以英文逗号分割)
   */
  @TableField("invoicerEmails")
  private String invoicerEmails;

  /**
   * 批次号
   */
  @TableField("batchNo")
  private String batchNo;

  /**
   * 开票完成时间
   */
  @TableField("issuedDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime issuedDate;

  /**
   * 申请单类型
   */
  @TableField("salesBillApplyType")
  private String salesBillApplyType;

  /**
   * 折扣含税金额
   */
  @TableField("discountWithTax")
  private BigDecimal discountWithTax;

  /**
   * 实开票不含税金额
   */
  @TableField("theActualWithoutTax")
  private BigDecimal theActualWithoutTax;

  /**
   * 实开票含税金额
   */
  @TableField("theActualWithTax")
  private BigDecimal theActualWithTax;

  /**
   * 实开票税额
   */
  @TableField("theActualTax")
  private BigDecimal theActualTax;

  /**
   * 已开含税金额
   */
  @TableField("alreadyMakeAmountWithTax")
  private BigDecimal alreadyMakeAmountWithTax;

  /**
   * 未开含税金额
   */
  @TableField("notMakeAmountWithTax")
  private BigDecimal notMakeAmountWithTax;

  /**
   * 物流收件人
   */
  private String addressee;

  /**
   * 物流收件人电话
   */
  @TableField("addresseePhone")
  private String addresseePhone;

  /**
   * 物流收件人省份
   */
  @TableField("addresseeProvince")
  private String addresseeProvince;

  /**
   * 物流收件人城市
   */
  @TableField("addresseeCity")
  private String addresseeCity;

  /**
   * 物流收件人所在县区
   */
  @TableField("addresseeCounty")
  private String addresseeCounty;

  /**
   * 物流收件人地址
   */
  @TableField("addresseeDirection")
  private String addresseeDirection;

  /**
   * 物流备注
   */
  @TableField("logisticsRemark")
  private String logisticsRemark;

  /**
   * 组织树
   */
  private String orgTree;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("salesbillNo", salesbillNo);
      map.put("sellerName", sellerName);
      map.put("sellerTaxNo", sellerTaxNo);
      map.put("buyerName", buyerName);
      map.put("buyerTaxNo", buyerTaxNo);
      map.put("buyerAddress", buyerAddress);
      map.put("buyerTel", buyerTel);
      map.put("buyerBankName", buyerBankName);
      map.put("buyerBankAccount", buyerBankAccount);
      map.put("invoiceType", invoiceType);
      map.put("originalInvoiceNo", originalInvoiceNo);
      map.put("originalInvoiceCode", originalInvoiceCode);
      map.put("mailingInfo", mailingInfo);
      map.put("emails", emails);
      map.put("failReason", failReason);
      map.put("orderRemark", orderRemark);
      map.put("remark", remark);
      map.put("redNo", redNo);
      map.put("srouce", srouce);
      map.put("abandonReason", abandonReason);
      map.put("group", group);
      map.put("creator", creator);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("applyUser", applyUser);
      map.put("applyUserId", applyUserId);
      map.put("applyTime", BocpGenUtils.toTimestamp(applyTime));
      map.put("applyUserEmail", applyUserEmail);
      map.put("examineUser", examineUser);
      map.put("examineUserId", examineUserId);
      map.put("examineUserEmail", examineUserEmail);
      map.put("examineTime", BocpGenUtils.toTimestamp(examineTime));
      map.put("auditingUser", auditingUser);
      map.put("auditingUserId", auditingUserId);
      map.put("auditingUserEmail", auditingUserEmail);
      map.put("auditingTime", BocpGenUtils.toTimestamp(auditingTime));
      map.put("taxAmount", taxAmount);
      map.put("amountWithoutTax", amountWithoutTax);
      map.put("amountWithTax", amountWithTax);
      map.put("applyNo", applyNo);
      map.put("salesBillStatus", salesBillStatus);
      map.put("pricingMethod", pricingMethod);
      map.put("auditingGroup", auditingGroup);
      map.put("uploadFailReason", uploadFailReason);
      map.put("contractNo", contractNo);
      map.put("otherReason", otherReason);
      map.put("internalType", internalType);
      map.put("uploadStatus", uploadStatus);
      map.put("sellerBankName", sellerBankName);
      map.put("sellerTel", sellerTel);
      map.put("sellerAddress", sellerAddress);
      map.put("sellerBankAccount", sellerBankAccount);
      map.put("originDateIssued", originDateIssued);
      map.put("originInvoiceType", originInvoiceType);
      map.put("reverseReason", reverseReason);
      map.put("applyGroup", applyGroup);
      map.put("examineGroup", examineGroup);
      map.put("appRemak", appRemak);
      map.put("invoicerEmails", invoicerEmails);
      map.put("batchNo", batchNo);
      map.put("issuedDate", BocpGenUtils.toTimestamp(issuedDate));
      map.put("salesBillApplyType", salesBillApplyType);
      map.put("discountWithTax", discountWithTax);
      map.put("theActualWithoutTax", theActualWithoutTax);
      map.put("theActualWithTax", theActualWithTax);
      map.put("theActualTax", theActualTax);
      map.put("alreadyMakeAmountWithTax", alreadyMakeAmountWithTax);
      map.put("notMakeAmountWithTax", notMakeAmountWithTax);
      map.put("addressee", addressee);
      map.put("addresseePhone", addresseePhone);
      map.put("addresseeProvince", addresseeProvince);
      map.put("addresseeCity", addresseeCity);
      map.put("addresseeCounty", addresseeCounty);
      map.put("addresseeDirection", addresseeDirection);
      map.put("logisticsRemark", logisticsRemark);
      map.put("org_tree", orgTree);

      return map;
  }

  public static SalesBill fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    SalesBill entity = new SalesBill();
    if(map.containsKey("salesbillNo")) {
      Object obj = map.get("salesbillNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSalesbillNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerName")) {
      Object obj = map.get("sellerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerTaxNo")) {
      Object obj = map.get("sellerTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyerName")) {
      Object obj = map.get("buyerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBuyerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyerTaxNo")) {
      Object obj = map.get("buyerTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBuyerTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyerAddress")) {
      Object obj = map.get("buyerAddress");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBuyerAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyerTel")) {
      Object obj = map.get("buyerTel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBuyerTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyerBankName")) {
      Object obj = map.get("buyerBankName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBuyerBankName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyerBankAccount")) {
      Object obj = map.get("buyerBankAccount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBuyerBankAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceType")) {
      Object obj = map.get("invoiceType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("originalInvoiceNo")) {
      Object obj = map.get("originalInvoiceNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOriginalInvoiceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("originalInvoiceCode")) {
      Object obj = map.get("originalInvoiceCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOriginalInvoiceCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("mailingInfo")) {
      Object obj = map.get("mailingInfo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMailingInfo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("emails")) {
      Object obj = map.get("emails");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setEmails((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("failReason")) {
      Object obj = map.get("failReason");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setFailReason((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("orderRemark")) {
      Object obj = map.get("orderRemark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrderRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("redNo")) {
      Object obj = map.get("redNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRedNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("srouce")) {
      Object obj = map.get("srouce");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSrouce((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("abandonReason")) {
      Object obj = map.get("abandonReason");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAbandonReason((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("group")) {
      Object obj = map.get("group");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setGroup((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("creator")) {
      Object obj = map.get("creator");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreator((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("applyUser")) {
      Object obj = map.get("applyUser");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setApplyUser((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("applyUserId")) {
      Object obj = map.get("applyUserId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setApplyUserId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("applyTime")) {
      Object obj = map.get("applyTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setApplyTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setApplyTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setApplyTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setApplyTime(null);
      }
    }
    if(map.containsKey("applyUserEmail")) {
      Object obj = map.get("applyUserEmail");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setApplyUserEmail((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("examineUser")) {
      Object obj = map.get("examineUser");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExamineUser((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("examineUserId")) {
      Object obj = map.get("examineUserId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExamineUserId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("examineUserEmail")) {
      Object obj = map.get("examineUserEmail");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExamineUserEmail((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("examineTime")) {
      Object obj = map.get("examineTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setExamineTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setExamineTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setExamineTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setExamineTime(null);
      }
    }
    if(map.containsKey("auditingUser")) {
      Object obj = map.get("auditingUser");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAuditingUser((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("auditingUserId")) {
      Object obj = map.get("auditingUserId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAuditingUserId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("auditingUserEmail")) {
      Object obj = map.get("auditingUserEmail");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAuditingUserEmail((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("auditingTime")) {
      Object obj = map.get("auditingTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setAuditingTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setAuditingTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAuditingTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setAuditingTime(null);
      }
    }
    if(map.containsKey("taxAmount")) {
      Object obj = map.get("taxAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("amountWithoutTax")) {
      Object obj = map.get("amountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("amountWithTax")) {
      Object obj = map.get("amountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("applyNo")) {
      Object obj = map.get("applyNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setApplyNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("salesBillStatus")) {
      Object obj = map.get("salesBillStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSalesBillStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pricingMethod")) {
      Object obj = map.get("pricingMethod");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPricingMethod((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("auditingGroup")) {
      Object obj = map.get("auditingGroup");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAuditingGroup((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("uploadFailReason")) {
      Object obj = map.get("uploadFailReason");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUploadFailReason((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("contractNo")) {
      Object obj = map.get("contractNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setContractNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("otherReason")) {
      Object obj = map.get("otherReason");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOtherReason((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("internalType")) {
      Object obj = map.get("internalType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInternalType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("uploadStatus")) {
      Object obj = map.get("uploadStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUploadStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerBankName")) {
      Object obj = map.get("sellerBankName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerBankName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerTel")) {
      Object obj = map.get("sellerTel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerAddress")) {
      Object obj = map.get("sellerAddress");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerBankAccount")) {
      Object obj = map.get("sellerBankAccount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerBankAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("originDateIssued")) {
      Object obj = map.get("originDateIssued");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOriginDateIssued((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("originInvoiceType")) {
      Object obj = map.get("originInvoiceType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOriginInvoiceType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("reverseReason")) {
      Object obj = map.get("reverseReason");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReverseReason((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("applyGroup")) {
      Object obj = map.get("applyGroup");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setApplyGroup((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("examineGroup")) {
      Object obj = map.get("examineGroup");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExamineGroup((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("appRemak")) {
      Object obj = map.get("appRemak");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAppRemak((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoicerEmails")) {
      Object obj = map.get("invoicerEmails");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoicerEmails((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("batchNo")) {
      Object obj = map.get("batchNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBatchNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("issuedDate")) {
      Object obj = map.get("issuedDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setIssuedDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setIssuedDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setIssuedDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setIssuedDate(null);
      }
    }
    if(map.containsKey("salesBillApplyType")) {
      Object obj = map.get("salesBillApplyType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSalesBillApplyType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("discountWithTax")) {
      Object obj = map.get("discountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setDiscountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setDiscountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setDiscountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setDiscountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setDiscountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("theActualWithoutTax")) {
      Object obj = map.get("theActualWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTheActualWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTheActualWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTheActualWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTheActualWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTheActualWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("theActualWithTax")) {
      Object obj = map.get("theActualWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTheActualWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTheActualWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTheActualWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTheActualWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTheActualWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("theActualTax")) {
      Object obj = map.get("theActualTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTheActualTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTheActualTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTheActualTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTheActualTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTheActualTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("alreadyMakeAmountWithTax")) {
      Object obj = map.get("alreadyMakeAmountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAlreadyMakeAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAlreadyMakeAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAlreadyMakeAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAlreadyMakeAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAlreadyMakeAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("notMakeAmountWithTax")) {
      Object obj = map.get("notMakeAmountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setNotMakeAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setNotMakeAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setNotMakeAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setNotMakeAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setNotMakeAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("addressee")) {
      Object obj = map.get("addressee");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAddressee((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("addresseePhone")) {
      Object obj = map.get("addresseePhone");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAddresseePhone((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("addresseeProvince")) {
      Object obj = map.get("addresseeProvince");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAddresseeProvince((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("addresseeCity")) {
      Object obj = map.get("addresseeCity");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAddresseeCity((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("addresseeCounty")) {
      Object obj = map.get("addresseeCounty");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAddresseeCounty((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("addresseeDirection")) {
      Object obj = map.get("addresseeDirection");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAddresseeDirection((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("logisticsRemark")) {
      Object obj = map.get("logisticsRemark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setLogisticsRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrgTree((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("salesbillNo")) {
      Object obj = map.get("salesbillNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSalesbillNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerName")) {
      Object obj = map.get("sellerName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerTaxNo")) {
      Object obj = map.get("sellerTaxNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerTaxNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("buyerName")) {
      Object obj = map.get("buyerName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBuyerName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("buyerTaxNo")) {
      Object obj = map.get("buyerTaxNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBuyerTaxNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("buyerAddress")) {
      Object obj = map.get("buyerAddress");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBuyerAddress((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("buyerTel")) {
      Object obj = map.get("buyerTel");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBuyerTel((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("buyerBankName")) {
      Object obj = map.get("buyerBankName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBuyerBankName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("buyerBankAccount")) {
      Object obj = map.get("buyerBankAccount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBuyerBankAccount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoiceType")) {
      Object obj = map.get("invoiceType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("originalInvoiceNo")) {
      Object obj = map.get("originalInvoiceNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOriginalInvoiceNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("originalInvoiceCode")) {
      Object obj = map.get("originalInvoiceCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOriginalInvoiceCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("mailingInfo")) {
      Object obj = map.get("mailingInfo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setMailingInfo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("emails")) {
      Object obj = map.get("emails");
      if(obj != null) {
        if(obj instanceof String) {
          this.setEmails((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("failReason")) {
      Object obj = map.get("failReason");
      if(obj != null) {
        if(obj instanceof String) {
          this.setFailReason((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("orderRemark")) {
      Object obj = map.get("orderRemark");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrderRemark((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRemark((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("redNo")) {
      Object obj = map.get("redNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRedNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("srouce")) {
      Object obj = map.get("srouce");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSrouce((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("abandonReason")) {
      Object obj = map.get("abandonReason");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAbandonReason((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("group")) {
      Object obj = map.get("group");
      if(obj != null) {
        if(obj instanceof String) {
          this.setGroup((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("creator")) {
      Object obj = map.get("creator");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreator((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("applyUser")) {
      Object obj = map.get("applyUser");
      if(obj != null) {
        if(obj instanceof String) {
          this.setApplyUser((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("applyUserId")) {
      Object obj = map.get("applyUserId");
      if(obj != null) {
        if(obj instanceof String) {
          this.setApplyUserId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("applyTime")) {
      Object obj = map.get("applyTime");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setApplyTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setApplyTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setApplyTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setApplyTime(null);
      }
    }
    if(map.containsKey("applyUserEmail")) {
      Object obj = map.get("applyUserEmail");
      if(obj != null) {
        if(obj instanceof String) {
          this.setApplyUserEmail((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("examineUser")) {
      Object obj = map.get("examineUser");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExamineUser((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("examineUserId")) {
      Object obj = map.get("examineUserId");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExamineUserId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("examineUserEmail")) {
      Object obj = map.get("examineUserEmail");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExamineUserEmail((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("examineTime")) {
      Object obj = map.get("examineTime");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setExamineTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setExamineTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setExamineTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setExamineTime(null);
      }
    }
    if(map.containsKey("auditingUser")) {
      Object obj = map.get("auditingUser");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAuditingUser((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("auditingUserId")) {
      Object obj = map.get("auditingUserId");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAuditingUserId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("auditingUserEmail")) {
      Object obj = map.get("auditingUserEmail");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAuditingUserEmail((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("auditingTime")) {
      Object obj = map.get("auditingTime");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setAuditingTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setAuditingTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setAuditingTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setAuditingTime(null);
      }
    }
    if(map.containsKey("taxAmount")) {
      Object obj = map.get("taxAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("amountWithoutTax")) {
      Object obj = map.get("amountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("amountWithTax")) {
      Object obj = map.get("amountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("applyNo")) {
      Object obj = map.get("applyNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setApplyNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("salesBillStatus")) {
      Object obj = map.get("salesBillStatus");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSalesBillStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("pricingMethod")) {
      Object obj = map.get("pricingMethod");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPricingMethod((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("auditingGroup")) {
      Object obj = map.get("auditingGroup");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAuditingGroup((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("uploadFailReason")) {
      Object obj = map.get("uploadFailReason");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUploadFailReason((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("contractNo")) {
      Object obj = map.get("contractNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setContractNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("otherReason")) {
      Object obj = map.get("otherReason");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOtherReason((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("internalType")) {
      Object obj = map.get("internalType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInternalType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("uploadStatus")) {
      Object obj = map.get("uploadStatus");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUploadStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerBankName")) {
      Object obj = map.get("sellerBankName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerBankName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerTel")) {
      Object obj = map.get("sellerTel");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerTel((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerAddress")) {
      Object obj = map.get("sellerAddress");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerAddress((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerBankAccount")) {
      Object obj = map.get("sellerBankAccount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerBankAccount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("originDateIssued")) {
      Object obj = map.get("originDateIssued");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOriginDateIssued((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("originInvoiceType")) {
      Object obj = map.get("originInvoiceType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOriginInvoiceType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("reverseReason")) {
      Object obj = map.get("reverseReason");
      if(obj != null) {
        if(obj instanceof String) {
          this.setReverseReason((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("applyGroup")) {
      Object obj = map.get("applyGroup");
      if(obj != null) {
        if(obj instanceof String) {
          this.setApplyGroup((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("examineGroup")) {
      Object obj = map.get("examineGroup");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExamineGroup((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("appRemak")) {
      Object obj = map.get("appRemak");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAppRemak((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoicerEmails")) {
      Object obj = map.get("invoicerEmails");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoicerEmails((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("batchNo")) {
      Object obj = map.get("batchNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBatchNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("issuedDate")) {
      Object obj = map.get("issuedDate");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setIssuedDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setIssuedDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setIssuedDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setIssuedDate(null);
      }
    }
    if(map.containsKey("salesBillApplyType")) {
      Object obj = map.get("salesBillApplyType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSalesBillApplyType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("discountWithTax")) {
      Object obj = map.get("discountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setDiscountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setDiscountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setDiscountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setDiscountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setDiscountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("theActualWithoutTax")) {
      Object obj = map.get("theActualWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setTheActualWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setTheActualWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setTheActualWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTheActualWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setTheActualWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("theActualWithTax")) {
      Object obj = map.get("theActualWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setTheActualWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setTheActualWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setTheActualWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTheActualWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setTheActualWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("theActualTax")) {
      Object obj = map.get("theActualTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setTheActualTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setTheActualTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setTheActualTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTheActualTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setTheActualTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("alreadyMakeAmountWithTax")) {
      Object obj = map.get("alreadyMakeAmountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setAlreadyMakeAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setAlreadyMakeAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setAlreadyMakeAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setAlreadyMakeAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setAlreadyMakeAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("notMakeAmountWithTax")) {
      Object obj = map.get("notMakeAmountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setNotMakeAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setNotMakeAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setNotMakeAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setNotMakeAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setNotMakeAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("addressee")) {
      Object obj = map.get("addressee");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAddressee((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("addresseePhone")) {
      Object obj = map.get("addresseePhone");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAddresseePhone((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("addresseeProvince")) {
      Object obj = map.get("addresseeProvince");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAddresseeProvince((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("addresseeCity")) {
      Object obj = map.get("addresseeCity");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAddresseeCity((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("addresseeCounty")) {
      Object obj = map.get("addresseeCounty");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAddresseeCounty((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("addresseeDirection")) {
      Object obj = map.get("addresseeDirection");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAddresseeDirection((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("logisticsRemark")) {
      Object obj = map.get("logisticsRemark");
      if(obj != null) {
        if(obj instanceof String) {
          this.setLogisticsRemark((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrgTree((String)obj);
        }
      } else {
      }
    }
  }
}
