package com.xforceplus.ultraman.app.jcwatsons.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2025-12-02
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class TaxNumberList implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 市场
   */
  private String market;

  /**
   * 区域
   */
  private String region;

  /**
   * 纳税人类型
   */
  @TableField("taxpayerType")
  private String taxpayerType;

  /**
   * 启停状态
   */
  @TableField("isOpen")
  private String isOpen;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * JV/PC
   */
  @TableField("jvPc")
  private String jvPc;

  /**
   * JV CODE
   */
  @TableField("jvCode")
  private String jvCode;

  /**
   * RMS代码
   */
  @TableField("rmsCode")
  private String rmsCode;

  /**
   * 公司编码
   */
  @TableField("companyCode")
  private String companyCode;

  /**
   * 公司名称
   */
  @TableField("companyName")
  private String companyName;

  /**
   * 公司税号
   */
  @TableField("companyTaxNo")
  private String companyTaxNo;

  /**
   * 税号主店
   */
  @TableField("mainStore")
  private String mainStore;

  /**
   * 归档账套
   */
  @TableField("archivalCover")
  private String archivalCover;

  /**
   * 成本中心
   */
  @TableField("costCenter")
  private String costCenter;

  /**
   * 开票员邮箱(多个以英文逗号分割)
   */
  @TableField("invoicerEmails")
  private String invoicerEmails;

  /**
   * 状态更新日期
   */
  @TableField("statusUpdateDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime statusUpdateDate;

  /**
   * 是否开具全电
   */
  @TableField("openAllElectricInvoice")
  private Boolean openAllElectricInvoice;

  /**
   * 审核人组别
   */
  @TableField("auditingGroup")
  private String auditingGroup;

  /**
   * 复核人组别
   */
  @TableField("examineGroup")
  private String examineGroup;

  /**
   * 红字是否自动上传税局
   */
  @TableField("redAutoUpload")
  private Boolean redAutoUpload;

  /**
   * 组织树
   */
  private String orgTree;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("market", market);
      map.put("region", region);
      map.put("taxpayerType", taxpayerType);
      map.put("isOpen", isOpen);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("jvPc", jvPc);
      map.put("jvCode", jvCode);
      map.put("rmsCode", rmsCode);
      map.put("companyCode", companyCode);
      map.put("companyName", companyName);
      map.put("companyTaxNo", companyTaxNo);
      map.put("mainStore", mainStore);
      map.put("archivalCover", archivalCover);
      map.put("costCenter", costCenter);
      map.put("invoicerEmails", invoicerEmails);
      map.put("statusUpdateDate", BocpGenUtils.toTimestamp(statusUpdateDate));
      map.put("openAllElectricInvoice", openAllElectricInvoice);
      map.put("auditingGroup", auditingGroup);
      map.put("examineGroup", examineGroup);
      map.put("redAutoUpload", redAutoUpload);
      map.put("org_tree", orgTree);

      return map;
  }

  public static TaxNumberList fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    TaxNumberList entity = new TaxNumberList();
    if(map.containsKey("market")) {
      Object obj = map.get("market");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMarket((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("region")) {
      Object obj = map.get("region");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRegion((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxpayerType")) {
      Object obj = map.get("taxpayerType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTaxpayerType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("isOpen")) {
      Object obj = map.get("isOpen");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setIsOpen((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("jvPc")) {
      Object obj = map.get("jvPc");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setJvPc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("jvCode")) {
      Object obj = map.get("jvCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setJvCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("rmsCode")) {
      Object obj = map.get("rmsCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRmsCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("companyCode")) {
      Object obj = map.get("companyCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCompanyCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("companyName")) {
      Object obj = map.get("companyName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCompanyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("companyTaxNo")) {
      Object obj = map.get("companyTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCompanyTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("mainStore")) {
      Object obj = map.get("mainStore");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMainStore((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("archivalCover")) {
      Object obj = map.get("archivalCover");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setArchivalCover((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("costCenter")) {
      Object obj = map.get("costCenter");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCostCenter((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoicerEmails")) {
      Object obj = map.get("invoicerEmails");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoicerEmails((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("statusUpdateDate")) {
      Object obj = map.get("statusUpdateDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setStatusUpdateDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setStatusUpdateDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setStatusUpdateDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setStatusUpdateDate(null);
      }
    }
    if(map.containsKey("openAllElectricInvoice")) {
      Object obj = map.get("openAllElectricInvoice");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setOpenAllElectricInvoice((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setOpenAllElectricInvoice(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("auditingGroup")) {
      Object obj = map.get("auditingGroup");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAuditingGroup((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("examineGroup")) {
      Object obj = map.get("examineGroup");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExamineGroup((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("redAutoUpload")) {
      Object obj = map.get("redAutoUpload");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setRedAutoUpload((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setRedAutoUpload(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrgTree((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("market")) {
      Object obj = map.get("market");
      if(obj != null) {
        if(obj instanceof String) {
          this.setMarket((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("region")) {
      Object obj = map.get("region");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRegion((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("taxpayerType")) {
      Object obj = map.get("taxpayerType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTaxpayerType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("isOpen")) {
      Object obj = map.get("isOpen");
      if(obj != null) {
        if(obj instanceof String) {
          this.setIsOpen((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("jvPc")) {
      Object obj = map.get("jvPc");
      if(obj != null) {
        if(obj instanceof String) {
          this.setJvPc((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("jvCode")) {
      Object obj = map.get("jvCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setJvCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("rmsCode")) {
      Object obj = map.get("rmsCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRmsCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("companyCode")) {
      Object obj = map.get("companyCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCompanyCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("companyName")) {
      Object obj = map.get("companyName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCompanyName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("companyTaxNo")) {
      Object obj = map.get("companyTaxNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCompanyTaxNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("mainStore")) {
      Object obj = map.get("mainStore");
      if(obj != null) {
        if(obj instanceof String) {
          this.setMainStore((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("archivalCover")) {
      Object obj = map.get("archivalCover");
      if(obj != null) {
        if(obj instanceof String) {
          this.setArchivalCover((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("costCenter")) {
      Object obj = map.get("costCenter");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCostCenter((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoicerEmails")) {
      Object obj = map.get("invoicerEmails");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoicerEmails((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("statusUpdateDate")) {
      Object obj = map.get("statusUpdateDate");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setStatusUpdateDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setStatusUpdateDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setStatusUpdateDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setStatusUpdateDate(null);
      }
    }
    if(map.containsKey("openAllElectricInvoice")) {
      Object obj = map.get("openAllElectricInvoice");
      if(obj != null) {
        if(obj instanceof Boolean) {
          this.setOpenAllElectricInvoice((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setOpenAllElectricInvoice(Boolean.valueOf((String)obj));
        }
      } else {
      }
    }
    if(map.containsKey("auditingGroup")) {
      Object obj = map.get("auditingGroup");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAuditingGroup((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("examineGroup")) {
      Object obj = map.get("examineGroup");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExamineGroup((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("redAutoUpload")) {
      Object obj = map.get("redAutoUpload");
      if(obj != null) {
        if(obj instanceof Boolean) {
          this.setRedAutoUpload((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setRedAutoUpload(Boolean.valueOf((String)obj));
        }
      } else {
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrgTree((String)obj);
        }
      } else {
      }
    }
  }
}
