package com.xforceplus.ultraman.app.jcwatsons.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * action_type
 * </p>
 *
 * @author ultraman
 * @since 2025-12-02
 */
public enum ActionType {

    REVOKE("revoke", "撤销操作"),
    AGREE("agree", "同意操作"),
    REJECT("reject", "拒绝操作"),
    APPLY("apply", "申请操作"),
    SYNC("sync", "同步操作");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    ActionType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ActionType fromCode(String code){
        switch(code) {
            case "revoke":
                return REVOKE;
            case "agree":
                return AGREE;
            case "reject":
                return REJECT;
            case "apply":
                return APPLY;
            case "sync":
                return SYNC;
            default:
                return null;
        }
    }
}
