package com.xforceplus.ultraman.app.jcwatsons.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * email_notice_channel
 * </p>
 *
 * @author ultraman
 * @since 2025-12-02
 */
public enum EmailNoticeChannel {

    _01("01", "内部交易开票"),
    _02("02", "MKT开票");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    EmailNoticeChannel(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static EmailNoticeChannel fromCode(String code){
        switch(code) {
            case "01":
                return _01;
            case "02":
                return _02;
            default:
                return null;
        }
    }
}
